/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.DownlinkMode;
import com.amazonaws.services.iotwireless.model.GatewayListItem;
import com.amazonaws.services.iotwireless.model.transform.ParticipatingGatewaysMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParticipatingGateways
implements Serializable,
Cloneable,
StructuredPojo {
    private String downlinkMode;
    private List<GatewayListItem> gatewayList;
    private Integer transmissionInterval;

    public void setDownlinkMode(String downlinkMode) {
        this.downlinkMode = downlinkMode;
    }

    public String getDownlinkMode() {
        return this.downlinkMode;
    }

    public ParticipatingGateways withDownlinkMode(String downlinkMode) {
        this.setDownlinkMode(downlinkMode);
        return this;
    }

    public ParticipatingGateways withDownlinkMode(DownlinkMode downlinkMode) {
        this.downlinkMode = downlinkMode.toString();
        return this;
    }

    public List<GatewayListItem> getGatewayList() {
        return this.gatewayList;
    }

    public void setGatewayList(Collection<GatewayListItem> gatewayList) {
        if (gatewayList == null) {
            this.gatewayList = null;
            return;
        }
        this.gatewayList = new ArrayList<GatewayListItem>(gatewayList);
    }

    public ParticipatingGateways withGatewayList(GatewayListItem ... gatewayList) {
        if (this.gatewayList == null) {
            this.setGatewayList(new ArrayList<GatewayListItem>(gatewayList.length));
        }
        for (GatewayListItem ele : gatewayList) {
            this.gatewayList.add(ele);
        }
        return this;
    }

    public ParticipatingGateways withGatewayList(Collection<GatewayListItem> gatewayList) {
        this.setGatewayList(gatewayList);
        return this;
    }

    public void setTransmissionInterval(Integer transmissionInterval) {
        this.transmissionInterval = transmissionInterval;
    }

    public Integer getTransmissionInterval() {
        return this.transmissionInterval;
    }

    public ParticipatingGateways withTransmissionInterval(Integer transmissionInterval) {
        this.setTransmissionInterval(transmissionInterval);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDownlinkMode() != null) {
            sb.append("DownlinkMode: ").append(this.getDownlinkMode()).append(",");
        }
        if (this.getGatewayList() != null) {
            sb.append("GatewayList: ").append(this.getGatewayList()).append(",");
        }
        if (this.getTransmissionInterval() != null) {
            sb.append("TransmissionInterval: ").append(this.getTransmissionInterval());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingGateways)) {
            return false;
        }
        ParticipatingGateways other = (ParticipatingGateways)obj;
        if (other.getDownlinkMode() == null ^ this.getDownlinkMode() == null) {
            return false;
        }
        if (other.getDownlinkMode() != null && !other.getDownlinkMode().equals(this.getDownlinkMode())) {
            return false;
        }
        if (other.getGatewayList() == null ^ this.getGatewayList() == null) {
            return false;
        }
        if (other.getGatewayList() != null && !other.getGatewayList().equals(this.getGatewayList())) {
            return false;
        }
        if (other.getTransmissionInterval() == null ^ this.getTransmissionInterval() == null) {
            return false;
        }
        return other.getTransmissionInterval() == null || other.getTransmissionInterval().equals(this.getTransmissionInterval());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDownlinkMode() == null ? 0 : this.getDownlinkMode().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayList() == null ? 0 : this.getGatewayList().hashCode());
        hashCode = 31 * hashCode + (this.getTransmissionInterval() == null ? 0 : this.getTransmissionInterval().hashCode());
        return hashCode;
    }

    public ParticipatingGateways clone() {
        try {
            return (ParticipatingGateways)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParticipatingGatewaysMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

