/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iottwinmaker.model.PropertySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPropertiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PropertySummary> propertySummaries;
    private String nextToken;

    public List<PropertySummary> getPropertySummaries() {
        return this.propertySummaries;
    }

    public void setPropertySummaries(Collection<PropertySummary> propertySummaries) {
        if (propertySummaries == null) {
            this.propertySummaries = null;
            return;
        }
        this.propertySummaries = new ArrayList<PropertySummary>(propertySummaries);
    }

    public ListPropertiesResult withPropertySummaries(PropertySummary ... propertySummaries) {
        if (this.propertySummaries == null) {
            this.setPropertySummaries(new ArrayList<PropertySummary>(propertySummaries.length));
        }
        for (PropertySummary ele : propertySummaries) {
            this.propertySummaries.add(ele);
        }
        return this;
    }

    public ListPropertiesResult withPropertySummaries(Collection<PropertySummary> propertySummaries) {
        this.setPropertySummaries(propertySummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPropertiesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPropertySummaries() != null) {
            sb.append("PropertySummaries: ").append(this.getPropertySummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPropertiesResult)) {
            return false;
        }
        ListPropertiesResult other = (ListPropertiesResult)obj;
        if (other.getPropertySummaries() == null ^ this.getPropertySummaries() == null) {
            return false;
        }
        if (other.getPropertySummaries() != null && !other.getPropertySummaries().equals(this.getPropertySummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPropertySummaries() == null ? 0 : this.getPropertySummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPropertiesResult clone() {
        try {
            return (ListPropertiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

