/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataType;
import java.util.List;

@SdkInternalApi
public class DataTypeMarshaller {
    private static final MarshallingInfo<List> ALLOWEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedValues").build();
    private static final MarshallingInfo<StructuredPojo> NESTEDTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nestedType").build();
    private static final MarshallingInfo<StructuredPojo> RELATIONSHIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationship").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> UNITOFMEASURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unitOfMeasure").build();
    private static final DataTypeMarshaller instance = new DataTypeMarshaller();

    public static DataTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataType dataType, ProtocolMarshaller protocolMarshaller) {
        if (dataType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataType.getAllowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)dataType.getNestedType(), NESTEDTYPE_BINDING);
            protocolMarshaller.marshall((Object)dataType.getRelationship(), RELATIONSHIP_BINDING);
            protocolMarshaller.marshall((Object)dataType.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataType.getUnitOfMeasure(), UNITOFMEASURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

