/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotfleetwise.model.DataFormat;
import com.amazonaws.services.iotfleetwise.model.StorageCompressionFormat;
import com.amazonaws.services.iotfleetwise.model.transform.S3ConfigMarshaller;
import java.io.Serializable;

public class S3Config
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketArn;
    private String dataFormat;
    private String storageCompressionFormat;
    private String prefix;

    public void setBucketArn(String bucketArn) {
        this.bucketArn = bucketArn;
    }

    public String getBucketArn() {
        return this.bucketArn;
    }

    public S3Config withBucketArn(String bucketArn) {
        this.setBucketArn(bucketArn);
        return this;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public S3Config withDataFormat(String dataFormat) {
        this.setDataFormat(dataFormat);
        return this;
    }

    public S3Config withDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat.toString();
        return this;
    }

    public void setStorageCompressionFormat(String storageCompressionFormat) {
        this.storageCompressionFormat = storageCompressionFormat;
    }

    public String getStorageCompressionFormat() {
        return this.storageCompressionFormat;
    }

    public S3Config withStorageCompressionFormat(String storageCompressionFormat) {
        this.setStorageCompressionFormat(storageCompressionFormat);
        return this;
    }

    public S3Config withStorageCompressionFormat(StorageCompressionFormat storageCompressionFormat) {
        this.storageCompressionFormat = storageCompressionFormat.toString();
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public S3Config withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketArn() != null) {
            sb.append("BucketArn: ").append(this.getBucketArn()).append(",");
        }
        if (this.getDataFormat() != null) {
            sb.append("DataFormat: ").append(this.getDataFormat()).append(",");
        }
        if (this.getStorageCompressionFormat() != null) {
            sb.append("StorageCompressionFormat: ").append(this.getStorageCompressionFormat()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config)obj;
        if (other.getBucketArn() == null ^ this.getBucketArn() == null) {
            return false;
        }
        if (other.getBucketArn() != null && !other.getBucketArn().equals(this.getBucketArn())) {
            return false;
        }
        if (other.getDataFormat() == null ^ this.getDataFormat() == null) {
            return false;
        }
        if (other.getDataFormat() != null && !other.getDataFormat().equals(this.getDataFormat())) {
            return false;
        }
        if (other.getStorageCompressionFormat() == null ^ this.getStorageCompressionFormat() == null) {
            return false;
        }
        if (other.getStorageCompressionFormat() != null && !other.getStorageCompressionFormat().equals(this.getStorageCompressionFormat())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        return other.getPrefix() == null || other.getPrefix().equals(this.getPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketArn() == null ? 0 : this.getBucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getDataFormat() == null ? 0 : this.getDataFormat().hashCode());
        hashCode = 31 * hashCode + (this.getStorageCompressionFormat() == null ? 0 : this.getStorageCompressionFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        return hashCode;
    }

    public S3Config clone() {
        try {
            return (S3Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

