/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.DeviceUnderTest;
import com.amazonaws.services.iotdeviceadvisor.model.transform.SuiteRunConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SuiteRunConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private DeviceUnderTest primaryDevice;
    private List<String> selectedTestList;
    private Boolean parallelRun;

    public void setPrimaryDevice(DeviceUnderTest primaryDevice) {
        this.primaryDevice = primaryDevice;
    }

    public DeviceUnderTest getPrimaryDevice() {
        return this.primaryDevice;
    }

    public SuiteRunConfiguration withPrimaryDevice(DeviceUnderTest primaryDevice) {
        this.setPrimaryDevice(primaryDevice);
        return this;
    }

    public List<String> getSelectedTestList() {
        return this.selectedTestList;
    }

    public void setSelectedTestList(Collection<String> selectedTestList) {
        if (selectedTestList == null) {
            this.selectedTestList = null;
            return;
        }
        this.selectedTestList = new ArrayList<String>(selectedTestList);
    }

    public SuiteRunConfiguration withSelectedTestList(String ... selectedTestList) {
        if (this.selectedTestList == null) {
            this.setSelectedTestList(new ArrayList<String>(selectedTestList.length));
        }
        for (String ele : selectedTestList) {
            this.selectedTestList.add(ele);
        }
        return this;
    }

    public SuiteRunConfiguration withSelectedTestList(Collection<String> selectedTestList) {
        this.setSelectedTestList(selectedTestList);
        return this;
    }

    public void setParallelRun(Boolean parallelRun) {
        this.parallelRun = parallelRun;
    }

    public Boolean getParallelRun() {
        return this.parallelRun;
    }

    public SuiteRunConfiguration withParallelRun(Boolean parallelRun) {
        this.setParallelRun(parallelRun);
        return this;
    }

    public Boolean isParallelRun() {
        return this.parallelRun;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrimaryDevice() != null) {
            sb.append("PrimaryDevice: ").append(this.getPrimaryDevice()).append(",");
        }
        if (this.getSelectedTestList() != null) {
            sb.append("SelectedTestList: ").append(this.getSelectedTestList()).append(",");
        }
        if (this.getParallelRun() != null) {
            sb.append("ParallelRun: ").append(this.getParallelRun());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunConfiguration)) {
            return false;
        }
        SuiteRunConfiguration other = (SuiteRunConfiguration)obj;
        if (other.getPrimaryDevice() == null ^ this.getPrimaryDevice() == null) {
            return false;
        }
        if (other.getPrimaryDevice() != null && !other.getPrimaryDevice().equals(this.getPrimaryDevice())) {
            return false;
        }
        if (other.getSelectedTestList() == null ^ this.getSelectedTestList() == null) {
            return false;
        }
        if (other.getSelectedTestList() != null && !other.getSelectedTestList().equals(this.getSelectedTestList())) {
            return false;
        }
        if (other.getParallelRun() == null ^ this.getParallelRun() == null) {
            return false;
        }
        return other.getParallelRun() == null || other.getParallelRun().equals(this.getParallelRun());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrimaryDevice() == null ? 0 : this.getPrimaryDevice().hashCode());
        hashCode = 31 * hashCode + (this.getSelectedTestList() == null ? 0 : this.getSelectedTestList().hashCode());
        hashCode = 31 * hashCode + (this.getParallelRun() == null ? 0 : this.getParallelRun().hashCode());
        return hashCode;
    }

    public SuiteRunConfiguration clone() {
        try {
            return (SuiteRunConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuiteRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

