/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.PackageSummary;
import java.util.Date;

@SdkInternalApi
public class PackageSummaryMarshaller {
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageName").build();
    private static final MarshallingInfo<String> DEFAULTVERSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultVersionName").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").timestampFormat("unixTimestamp").build();
    private static final PackageSummaryMarshaller instance = new PackageSummaryMarshaller();

    public static PackageSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageSummary packageSummary, ProtocolMarshaller protocolMarshaller) {
        if (packageSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)packageSummary.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)packageSummary.getDefaultVersionName(), DEFAULTVERSIONNAME_BINDING);
            protocolMarshaller.marshall((Object)packageSummary.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)packageSummary.getLastModifiedDate(), LASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

