/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.Bucket;

@SdkInternalApi
public class BucketMarshaller {
    private static final MarshallingInfo<String> KEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyValue").build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final BucketMarshaller instance = new BucketMarshaller();

    public static BucketMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bucket bucket, ProtocolMarshaller protocolMarshaller) {
        if (bucket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bucket.getKeyValue(), KEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)bucket.getCount(), COUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

