/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.ThingConnectivity;
import com.amazonaws.services.iot.model.transform.ThingDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThingDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private String thingName;
    private String thingId;
    private String thingTypeName;
    private List<String> thingGroupNames;
    private Map<String, String> attributes;
    private String shadow;
    private String deviceDefender;
    private ThingConnectivity connectivity;

    public void setThingName(String thingName) {
        this.thingName = thingName;
    }

    public String getThingName() {
        return this.thingName;
    }

    public ThingDocument withThingName(String thingName) {
        this.setThingName(thingName);
        return this;
    }

    public void setThingId(String thingId) {
        this.thingId = thingId;
    }

    public String getThingId() {
        return this.thingId;
    }

    public ThingDocument withThingId(String thingId) {
        this.setThingId(thingId);
        return this;
    }

    public void setThingTypeName(String thingTypeName) {
        this.thingTypeName = thingTypeName;
    }

    public String getThingTypeName() {
        return this.thingTypeName;
    }

    public ThingDocument withThingTypeName(String thingTypeName) {
        this.setThingTypeName(thingTypeName);
        return this;
    }

    public List<String> getThingGroupNames() {
        return this.thingGroupNames;
    }

    public void setThingGroupNames(Collection<String> thingGroupNames) {
        if (thingGroupNames == null) {
            this.thingGroupNames = null;
            return;
        }
        this.thingGroupNames = new ArrayList<String>(thingGroupNames);
    }

    public ThingDocument withThingGroupNames(String ... thingGroupNames) {
        if (this.thingGroupNames == null) {
            this.setThingGroupNames(new ArrayList<String>(thingGroupNames.length));
        }
        for (String ele : thingGroupNames) {
            this.thingGroupNames.add(ele);
        }
        return this;
    }

    public ThingDocument withThingGroupNames(Collection<String> thingGroupNames) {
        this.setThingGroupNames(thingGroupNames);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThingDocument withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public ThingDocument addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public ThingDocument clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setShadow(String shadow) {
        this.shadow = shadow;
    }

    public String getShadow() {
        return this.shadow;
    }

    public ThingDocument withShadow(String shadow) {
        this.setShadow(shadow);
        return this;
    }

    public void setDeviceDefender(String deviceDefender) {
        this.deviceDefender = deviceDefender;
    }

    public String getDeviceDefender() {
        return this.deviceDefender;
    }

    public ThingDocument withDeviceDefender(String deviceDefender) {
        this.setDeviceDefender(deviceDefender);
        return this;
    }

    public void setConnectivity(ThingConnectivity connectivity) {
        this.connectivity = connectivity;
    }

    public ThingConnectivity getConnectivity() {
        return this.connectivity;
    }

    public ThingDocument withConnectivity(ThingConnectivity connectivity) {
        this.setConnectivity(connectivity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getThingName() != null) {
            sb.append("ThingName: ").append(this.getThingName()).append(",");
        }
        if (this.getThingId() != null) {
            sb.append("ThingId: ").append(this.getThingId()).append(",");
        }
        if (this.getThingTypeName() != null) {
            sb.append("ThingTypeName: ").append(this.getThingTypeName()).append(",");
        }
        if (this.getThingGroupNames() != null) {
            sb.append("ThingGroupNames: ").append(this.getThingGroupNames()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getShadow() != null) {
            sb.append("Shadow: ").append(this.getShadow()).append(",");
        }
        if (this.getDeviceDefender() != null) {
            sb.append("DeviceDefender: ").append(this.getDeviceDefender()).append(",");
        }
        if (this.getConnectivity() != null) {
            sb.append("Connectivity: ").append(this.getConnectivity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument)obj;
        if (other.getThingName() == null ^ this.getThingName() == null) {
            return false;
        }
        if (other.getThingName() != null && !other.getThingName().equals(this.getThingName())) {
            return false;
        }
        if (other.getThingId() == null ^ this.getThingId() == null) {
            return false;
        }
        if (other.getThingId() != null && !other.getThingId().equals(this.getThingId())) {
            return false;
        }
        if (other.getThingTypeName() == null ^ this.getThingTypeName() == null) {
            return false;
        }
        if (other.getThingTypeName() != null && !other.getThingTypeName().equals(this.getThingTypeName())) {
            return false;
        }
        if (other.getThingGroupNames() == null ^ this.getThingGroupNames() == null) {
            return false;
        }
        if (other.getThingGroupNames() != null && !other.getThingGroupNames().equals(this.getThingGroupNames())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getShadow() == null ^ this.getShadow() == null) {
            return false;
        }
        if (other.getShadow() != null && !other.getShadow().equals(this.getShadow())) {
            return false;
        }
        if (other.getDeviceDefender() == null ^ this.getDeviceDefender() == null) {
            return false;
        }
        if (other.getDeviceDefender() != null && !other.getDeviceDefender().equals(this.getDeviceDefender())) {
            return false;
        }
        if (other.getConnectivity() == null ^ this.getConnectivity() == null) {
            return false;
        }
        return other.getConnectivity() == null || other.getConnectivity().equals(this.getConnectivity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getThingName() == null ? 0 : this.getThingName().hashCode());
        hashCode = 31 * hashCode + (this.getThingId() == null ? 0 : this.getThingId().hashCode());
        hashCode = 31 * hashCode + (this.getThingTypeName() == null ? 0 : this.getThingTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getThingGroupNames() == null ? 0 : this.getThingGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getShadow() == null ? 0 : this.getShadow().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceDefender() == null ? 0 : this.getDeviceDefender().hashCode());
        hashCode = 31 * hashCode + (this.getConnectivity() == null ? 0 : this.getConnectivity().hashCode());
        return hashCode;
    }

    public ThingDocument clone() {
        try {
            return (ThingDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

