/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.JobEndBehavior;
import com.amazonaws.services.iot.model.MaintenanceWindow;
import com.amazonaws.services.iot.model.transform.SchedulingConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchedulingConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String startTime;
    private String endTime;
    private String endBehavior;
    private List<MaintenanceWindow> maintenanceWindows;

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public SchedulingConfig withStartTime(String startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public SchedulingConfig withEndTime(String endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setEndBehavior(String endBehavior) {
        this.endBehavior = endBehavior;
    }

    public String getEndBehavior() {
        return this.endBehavior;
    }

    public SchedulingConfig withEndBehavior(String endBehavior) {
        this.setEndBehavior(endBehavior);
        return this;
    }

    public SchedulingConfig withEndBehavior(JobEndBehavior endBehavior) {
        this.endBehavior = endBehavior.toString();
        return this;
    }

    public List<MaintenanceWindow> getMaintenanceWindows() {
        return this.maintenanceWindows;
    }

    public void setMaintenanceWindows(Collection<MaintenanceWindow> maintenanceWindows) {
        if (maintenanceWindows == null) {
            this.maintenanceWindows = null;
            return;
        }
        this.maintenanceWindows = new ArrayList<MaintenanceWindow>(maintenanceWindows);
    }

    public SchedulingConfig withMaintenanceWindows(MaintenanceWindow ... maintenanceWindows) {
        if (this.maintenanceWindows == null) {
            this.setMaintenanceWindows(new ArrayList<MaintenanceWindow>(maintenanceWindows.length));
        }
        for (MaintenanceWindow ele : maintenanceWindows) {
            this.maintenanceWindows.add(ele);
        }
        return this;
    }

    public SchedulingConfig withMaintenanceWindows(Collection<MaintenanceWindow> maintenanceWindows) {
        this.setMaintenanceWindows(maintenanceWindows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getEndBehavior() != null) {
            sb.append("EndBehavior: ").append(this.getEndBehavior()).append(",");
        }
        if (this.getMaintenanceWindows() != null) {
            sb.append("MaintenanceWindows: ").append(this.getMaintenanceWindows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulingConfig)) {
            return false;
        }
        SchedulingConfig other = (SchedulingConfig)obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getEndBehavior() == null ^ this.getEndBehavior() == null) {
            return false;
        }
        if (other.getEndBehavior() != null && !other.getEndBehavior().equals(this.getEndBehavior())) {
            return false;
        }
        if (other.getMaintenanceWindows() == null ^ this.getMaintenanceWindows() == null) {
            return false;
        }
        return other.getMaintenanceWindows() == null || other.getMaintenanceWindows().equals(this.getMaintenanceWindows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndBehavior() == null ? 0 : this.getEndBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceWindows() == null ? 0 : this.getMaintenanceWindows().hashCode());
        return hashCode;
    }

    public SchedulingConfig clone() {
        try {
            return (SchedulingConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchedulingConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

