/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.AuditMitigationActionsTaskStatus;
import com.amazonaws.services.iot.model.AuditMitigationActionsTaskTarget;
import com.amazonaws.services.iot.model.MitigationAction;
import com.amazonaws.services.iot.model.TaskStatisticsForAuditCheck;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeAuditMitigationActionsTaskResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String taskStatus;
    private Date startTime;
    private Date endTime;
    private Map<String, TaskStatisticsForAuditCheck> taskStatistics;
    private AuditMitigationActionsTaskTarget target;
    private Map<String, List<String>> auditCheckToActionsMapping;
    private List<MitigationAction> actionsDefinition;

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public DescribeAuditMitigationActionsTaskResult withTaskStatus(String taskStatus) {
        this.setTaskStatus(taskStatus);
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult withTaskStatus(AuditMitigationActionsTaskStatus taskStatus) {
        this.taskStatus = taskStatus.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public DescribeAuditMitigationActionsTaskResult withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public DescribeAuditMitigationActionsTaskResult withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public Map<String, TaskStatisticsForAuditCheck> getTaskStatistics() {
        return this.taskStatistics;
    }

    public void setTaskStatistics(Map<String, TaskStatisticsForAuditCheck> taskStatistics) {
        this.taskStatistics = taskStatistics;
    }

    public DescribeAuditMitigationActionsTaskResult withTaskStatistics(Map<String, TaskStatisticsForAuditCheck> taskStatistics) {
        this.setTaskStatistics(taskStatistics);
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult addTaskStatisticsEntry(String key, TaskStatisticsForAuditCheck value) {
        if (null == this.taskStatistics) {
            this.taskStatistics = new HashMap<String, TaskStatisticsForAuditCheck>();
        }
        if (this.taskStatistics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.taskStatistics.put(key, value);
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult clearTaskStatisticsEntries() {
        this.taskStatistics = null;
        return this;
    }

    public void setTarget(AuditMitigationActionsTaskTarget target) {
        this.target = target;
    }

    public AuditMitigationActionsTaskTarget getTarget() {
        return this.target;
    }

    public DescribeAuditMitigationActionsTaskResult withTarget(AuditMitigationActionsTaskTarget target) {
        this.setTarget(target);
        return this;
    }

    public Map<String, List<String>> getAuditCheckToActionsMapping() {
        return this.auditCheckToActionsMapping;
    }

    public void setAuditCheckToActionsMapping(Map<String, List<String>> auditCheckToActionsMapping) {
        this.auditCheckToActionsMapping = auditCheckToActionsMapping;
    }

    public DescribeAuditMitigationActionsTaskResult withAuditCheckToActionsMapping(Map<String, List<String>> auditCheckToActionsMapping) {
        this.setAuditCheckToActionsMapping(auditCheckToActionsMapping);
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult addAuditCheckToActionsMappingEntry(String key, List<String> value) {
        if (null == this.auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = new HashMap<String, List<String>>();
        }
        if (this.auditCheckToActionsMapping.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.auditCheckToActionsMapping.put(key, value);
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult clearAuditCheckToActionsMappingEntries() {
        this.auditCheckToActionsMapping = null;
        return this;
    }

    public List<MitigationAction> getActionsDefinition() {
        return this.actionsDefinition;
    }

    public void setActionsDefinition(Collection<MitigationAction> actionsDefinition) {
        if (actionsDefinition == null) {
            this.actionsDefinition = null;
            return;
        }
        this.actionsDefinition = new ArrayList<MitigationAction>(actionsDefinition);
    }

    public DescribeAuditMitigationActionsTaskResult withActionsDefinition(MitigationAction ... actionsDefinition) {
        if (this.actionsDefinition == null) {
            this.setActionsDefinition(new ArrayList<MitigationAction>(actionsDefinition.length));
        }
        for (MitigationAction ele : actionsDefinition) {
            this.actionsDefinition.add(ele);
        }
        return this;
    }

    public DescribeAuditMitigationActionsTaskResult withActionsDefinition(Collection<MitigationAction> actionsDefinition) {
        this.setActionsDefinition(actionsDefinition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskStatus() != null) {
            sb.append("TaskStatus: ").append(this.getTaskStatus()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getTaskStatistics() != null) {
            sb.append("TaskStatistics: ").append(this.getTaskStatistics()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget()).append(",");
        }
        if (this.getAuditCheckToActionsMapping() != null) {
            sb.append("AuditCheckToActionsMapping: ").append(this.getAuditCheckToActionsMapping()).append(",");
        }
        if (this.getActionsDefinition() != null) {
            sb.append("ActionsDefinition: ").append(this.getActionsDefinition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditMitigationActionsTaskResult)) {
            return false;
        }
        DescribeAuditMitigationActionsTaskResult other = (DescribeAuditMitigationActionsTaskResult)obj;
        if (other.getTaskStatus() == null ^ this.getTaskStatus() == null) {
            return false;
        }
        if (other.getTaskStatus() != null && !other.getTaskStatus().equals(this.getTaskStatus())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getTaskStatistics() == null ^ this.getTaskStatistics() == null) {
            return false;
        }
        if (other.getTaskStatistics() != null && !other.getTaskStatistics().equals(this.getTaskStatistics())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        if (other.getTarget() != null && !other.getTarget().equals(this.getTarget())) {
            return false;
        }
        if (other.getAuditCheckToActionsMapping() == null ^ this.getAuditCheckToActionsMapping() == null) {
            return false;
        }
        if (other.getAuditCheckToActionsMapping() != null && !other.getAuditCheckToActionsMapping().equals(this.getAuditCheckToActionsMapping())) {
            return false;
        }
        if (other.getActionsDefinition() == null ^ this.getActionsDefinition() == null) {
            return false;
        }
        return other.getActionsDefinition() == null || other.getActionsDefinition().equals(this.getActionsDefinition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskStatus() == null ? 0 : this.getTaskStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getTaskStatistics() == null ? 0 : this.getTaskStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hashCode = 31 * hashCode + (this.getAuditCheckToActionsMapping() == null ? 0 : this.getAuditCheckToActionsMapping().hashCode());
        hashCode = 31 * hashCode + (this.getActionsDefinition() == null ? 0 : this.getActionsDefinition().hashCode());
        return hashCode;
    }

    public DescribeAuditMitigationActionsTaskResult clone() {
        try {
            return (DescribeAuditMitigationActionsTaskResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

