/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.Statistics;

@SdkInternalApi
public class StatisticsMarshaller {
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("average").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sum").build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimum").build();
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximum").build();
    private static final MarshallingInfo<Double> SUMOFSQUARES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sumOfSquares").build();
    private static final MarshallingInfo<Double> VARIANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variance").build();
    private static final MarshallingInfo<Double> STDDEVIATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stdDeviation").build();
    private static final StatisticsMarshaller instance = new StatisticsMarshaller();

    public static StatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Statistics statistics, ProtocolMarshaller protocolMarshaller) {
        if (statistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)statistics.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)statistics.getAverage(), AVERAGE_BINDING);
            protocolMarshaller.marshall((Object)statistics.getSum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)statistics.getMinimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)statistics.getMaximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)statistics.getSumOfSquares(), SUMOFSQUARES_BINDING);
            protocolMarshaller.marshall((Object)statistics.getVariance(), VARIANCE_BINDING);
            protocolMarshaller.marshall((Object)statistics.getStdDeviation(), STDDEVIATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

