/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.PackageSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPackagesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PackageSummary> packageSummaries;
    private String nextToken;

    public List<PackageSummary> getPackageSummaries() {
        return this.packageSummaries;
    }

    public void setPackageSummaries(Collection<PackageSummary> packageSummaries) {
        if (packageSummaries == null) {
            this.packageSummaries = null;
            return;
        }
        this.packageSummaries = new ArrayList<PackageSummary>(packageSummaries);
    }

    public ListPackagesResult withPackageSummaries(PackageSummary ... packageSummaries) {
        if (this.packageSummaries == null) {
            this.setPackageSummaries(new ArrayList<PackageSummary>(packageSummaries.length));
        }
        for (PackageSummary ele : packageSummaries) {
            this.packageSummaries.add(ele);
        }
        return this;
    }

    public ListPackagesResult withPackageSummaries(Collection<PackageSummary> packageSummaries) {
        this.setPackageSummaries(packageSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPackagesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageSummaries() != null) {
            sb.append("PackageSummaries: ").append(this.getPackageSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagesResult)) {
            return false;
        }
        ListPackagesResult other = (ListPackagesResult)obj;
        if (other.getPackageSummaries() == null ^ this.getPackageSummaries() == null) {
            return false;
        }
        if (other.getPackageSummaries() != null && !other.getPackageSummaries().equals(this.getPackageSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageSummaries() == null ? 0 : this.getPackageSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPackagesResult clone() {
        try {
            return (ListPackagesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

