/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.AuditFrequency;
import com.amazonaws.services.iot.model.DayOfWeek;
import com.amazonaws.services.iot.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateScheduledAuditRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String frequency;
    private String dayOfMonth;
    private String dayOfWeek;
    private List<String> targetCheckNames;
    private String scheduledAuditName;
    private List<Tag> tags;

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public CreateScheduledAuditRequest withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public CreateScheduledAuditRequest withFrequency(AuditFrequency frequency) {
        this.frequency = frequency.toString();
        return this;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public CreateScheduledAuditRequest withDayOfMonth(String dayOfMonth) {
        this.setDayOfMonth(dayOfMonth);
        return this;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public CreateScheduledAuditRequest withDayOfWeek(String dayOfWeek) {
        this.setDayOfWeek(dayOfWeek);
        return this;
    }

    public CreateScheduledAuditRequest withDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek.toString();
        return this;
    }

    public List<String> getTargetCheckNames() {
        return this.targetCheckNames;
    }

    public void setTargetCheckNames(Collection<String> targetCheckNames) {
        if (targetCheckNames == null) {
            this.targetCheckNames = null;
            return;
        }
        this.targetCheckNames = new ArrayList<String>(targetCheckNames);
    }

    public CreateScheduledAuditRequest withTargetCheckNames(String ... targetCheckNames) {
        if (this.targetCheckNames == null) {
            this.setTargetCheckNames(new ArrayList<String>(targetCheckNames.length));
        }
        for (String ele : targetCheckNames) {
            this.targetCheckNames.add(ele);
        }
        return this;
    }

    public CreateScheduledAuditRequest withTargetCheckNames(Collection<String> targetCheckNames) {
        this.setTargetCheckNames(targetCheckNames);
        return this;
    }

    public void setScheduledAuditName(String scheduledAuditName) {
        this.scheduledAuditName = scheduledAuditName;
    }

    public String getScheduledAuditName() {
        return this.scheduledAuditName;
    }

    public CreateScheduledAuditRequest withScheduledAuditName(String scheduledAuditName) {
        this.setScheduledAuditName(scheduledAuditName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateScheduledAuditRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateScheduledAuditRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency()).append(",");
        }
        if (this.getDayOfMonth() != null) {
            sb.append("DayOfMonth: ").append(this.getDayOfMonth()).append(",");
        }
        if (this.getDayOfWeek() != null) {
            sb.append("DayOfWeek: ").append(this.getDayOfWeek()).append(",");
        }
        if (this.getTargetCheckNames() != null) {
            sb.append("TargetCheckNames: ").append(this.getTargetCheckNames()).append(",");
        }
        if (this.getScheduledAuditName() != null) {
            sb.append("ScheduledAuditName: ").append(this.getScheduledAuditName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledAuditRequest)) {
            return false;
        }
        CreateScheduledAuditRequest other = (CreateScheduledAuditRequest)obj;
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getDayOfMonth() == null ^ this.getDayOfMonth() == null) {
            return false;
        }
        if (other.getDayOfMonth() != null && !other.getDayOfMonth().equals(this.getDayOfMonth())) {
            return false;
        }
        if (other.getDayOfWeek() == null ^ this.getDayOfWeek() == null) {
            return false;
        }
        if (other.getDayOfWeek() != null && !other.getDayOfWeek().equals(this.getDayOfWeek())) {
            return false;
        }
        if (other.getTargetCheckNames() == null ^ this.getTargetCheckNames() == null) {
            return false;
        }
        if (other.getTargetCheckNames() != null && !other.getTargetCheckNames().equals(this.getTargetCheckNames())) {
            return false;
        }
        if (other.getScheduledAuditName() == null ^ this.getScheduledAuditName() == null) {
            return false;
        }
        if (other.getScheduledAuditName() != null && !other.getScheduledAuditName().equals(this.getScheduledAuditName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getDayOfMonth() == null ? 0 : this.getDayOfMonth().hashCode());
        hashCode = 31 * hashCode + (this.getDayOfWeek() == null ? 0 : this.getDayOfWeek().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCheckNames() == null ? 0 : this.getTargetCheckNames().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledAuditName() == null ? 0 : this.getScheduledAuditName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateScheduledAuditRequest clone() {
        return (CreateScheduledAuditRequest)super.clone();
    }
}

