/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.ResourceIdentifier;
import com.amazonaws.services.iot.model.ResourceType;
import com.amazonaws.services.iot.model.transform.NonCompliantResourceMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class NonCompliantResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private ResourceIdentifier resourceIdentifier;
    private Map<String, String> additionalInfo;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public NonCompliantResource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public NonCompliantResource withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setResourceIdentifier(ResourceIdentifier resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public ResourceIdentifier getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public NonCompliantResource withResourceIdentifier(ResourceIdentifier resourceIdentifier) {
        this.setResourceIdentifier(resourceIdentifier);
        return this;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public NonCompliantResource withAdditionalInfo(Map<String, String> additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public NonCompliantResource addAdditionalInfoEntry(String key, String value) {
        if (null == this.additionalInfo) {
            this.additionalInfo = new HashMap<String, String>();
        }
        if (this.additionalInfo.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalInfo.put(key, value);
        return this;
    }

    public NonCompliantResource clearAdditionalInfoEntries() {
        this.additionalInfo = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.getResourceIdentifier()).append(",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.getAdditionalInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantResource)) {
            return false;
        }
        NonCompliantResource other = (NonCompliantResource)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIdentifier() == null ^ this.getResourceIdentifier() == null) {
            return false;
        }
        if (other.getResourceIdentifier() != null && !other.getResourceIdentifier().equals(this.getResourceIdentifier())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        return other.getAdditionalInfo() == null || other.getAdditionalInfo().equals(this.getAdditionalInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifier() == null ? 0 : this.getResourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        return hashCode;
    }

    public NonCompliantResource clone() {
        try {
            return (NonCompliantResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NonCompliantResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

