/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.internetmonitor.model.ClientLocation;

@SdkInternalApi
public class ClientLocationMarshaller {
    private static final MarshallingInfo<String> ASNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ASName").build();
    private static final MarshallingInfo<Long> ASNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ASNumber").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<String> SUBDIVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subdivision").build();
    private static final MarshallingInfo<String> METRO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metro").build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").build();
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latitude").build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Longitude").build();
    private static final ClientLocationMarshaller instance = new ClientLocationMarshaller();

    public static ClientLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClientLocation clientLocation, ProtocolMarshaller protocolMarshaller) {
        if (clientLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clientLocation.getASName(), ASNAME_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getASNumber(), ASNUMBER_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getSubdivision(), SUBDIVISION_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getMetro(), METRO_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getCity(), CITY_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getLatitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)clientLocation.getLongitude(), LONGITUDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

