/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.internetmonitor.AmazonInternetMonitorAsync;
import com.amazonaws.services.internetmonitor.AmazonInternetMonitorAsyncClientBuilder;
import com.amazonaws.services.internetmonitor.AmazonInternetMonitorClient;
import com.amazonaws.services.internetmonitor.model.CreateMonitorRequest;
import com.amazonaws.services.internetmonitor.model.CreateMonitorResult;
import com.amazonaws.services.internetmonitor.model.DeleteMonitorRequest;
import com.amazonaws.services.internetmonitor.model.DeleteMonitorResult;
import com.amazonaws.services.internetmonitor.model.GetHealthEventRequest;
import com.amazonaws.services.internetmonitor.model.GetHealthEventResult;
import com.amazonaws.services.internetmonitor.model.GetInternetEventRequest;
import com.amazonaws.services.internetmonitor.model.GetInternetEventResult;
import com.amazonaws.services.internetmonitor.model.GetMonitorRequest;
import com.amazonaws.services.internetmonitor.model.GetMonitorResult;
import com.amazonaws.services.internetmonitor.model.GetQueryResultsRequest;
import com.amazonaws.services.internetmonitor.model.GetQueryResultsResult;
import com.amazonaws.services.internetmonitor.model.GetQueryStatusRequest;
import com.amazonaws.services.internetmonitor.model.GetQueryStatusResult;
import com.amazonaws.services.internetmonitor.model.ListHealthEventsRequest;
import com.amazonaws.services.internetmonitor.model.ListHealthEventsResult;
import com.amazonaws.services.internetmonitor.model.ListInternetEventsRequest;
import com.amazonaws.services.internetmonitor.model.ListInternetEventsResult;
import com.amazonaws.services.internetmonitor.model.ListMonitorsRequest;
import com.amazonaws.services.internetmonitor.model.ListMonitorsResult;
import com.amazonaws.services.internetmonitor.model.ListTagsForResourceRequest;
import com.amazonaws.services.internetmonitor.model.ListTagsForResourceResult;
import com.amazonaws.services.internetmonitor.model.StartQueryRequest;
import com.amazonaws.services.internetmonitor.model.StartQueryResult;
import com.amazonaws.services.internetmonitor.model.StopQueryRequest;
import com.amazonaws.services.internetmonitor.model.StopQueryResult;
import com.amazonaws.services.internetmonitor.model.TagResourceRequest;
import com.amazonaws.services.internetmonitor.model.TagResourceResult;
import com.amazonaws.services.internetmonitor.model.UntagResourceRequest;
import com.amazonaws.services.internetmonitor.model.UntagResourceResult;
import com.amazonaws.services.internetmonitor.model.UpdateMonitorRequest;
import com.amazonaws.services.internetmonitor.model.UpdateMonitorResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonInternetMonitorAsyncClient
extends AmazonInternetMonitorClient
implements AmazonInternetMonitorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonInternetMonitorAsyncClientBuilder asyncBuilder() {
        return AmazonInternetMonitorAsyncClientBuilder.standard();
    }

    AmazonInternetMonitorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonInternetMonitorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request) {
        return this.createMonitorAsync(request, null);
    }

    @Override
    public Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request, final AsyncHandler<CreateMonitorRequest, CreateMonitorResult> asyncHandler) {
        final CreateMonitorRequest finalRequest = (CreateMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMonitorResult>(){

            @Override
            public CreateMonitorResult call() throws Exception {
                CreateMonitorResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeCreateMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request) {
        return this.deleteMonitorAsync(request, null);
    }

    @Override
    public Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request, final AsyncHandler<DeleteMonitorRequest, DeleteMonitorResult> asyncHandler) {
        final DeleteMonitorRequest finalRequest = (DeleteMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMonitorResult>(){

            @Override
            public DeleteMonitorResult call() throws Exception {
                DeleteMonitorResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeDeleteMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHealthEventResult> getHealthEventAsync(GetHealthEventRequest request) {
        return this.getHealthEventAsync(request, null);
    }

    @Override
    public Future<GetHealthEventResult> getHealthEventAsync(GetHealthEventRequest request, final AsyncHandler<GetHealthEventRequest, GetHealthEventResult> asyncHandler) {
        final GetHealthEventRequest finalRequest = (GetHealthEventRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetHealthEventResult>(){

            @Override
            public GetHealthEventResult call() throws Exception {
                GetHealthEventResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeGetHealthEvent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInternetEventResult> getInternetEventAsync(GetInternetEventRequest request) {
        return this.getInternetEventAsync(request, null);
    }

    @Override
    public Future<GetInternetEventResult> getInternetEventAsync(GetInternetEventRequest request, final AsyncHandler<GetInternetEventRequest, GetInternetEventResult> asyncHandler) {
        final GetInternetEventRequest finalRequest = (GetInternetEventRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInternetEventResult>(){

            @Override
            public GetInternetEventResult call() throws Exception {
                GetInternetEventResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeGetInternetEvent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request) {
        return this.getMonitorAsync(request, null);
    }

    @Override
    public Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request, final AsyncHandler<GetMonitorRequest, GetMonitorResult> asyncHandler) {
        final GetMonitorRequest finalRequest = (GetMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMonitorResult>(){

            @Override
            public GetMonitorResult call() throws Exception {
                GetMonitorResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeGetMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request) {
        return this.getQueryResultsAsync(request, null);
    }

    @Override
    public Future<GetQueryResultsResult> getQueryResultsAsync(GetQueryResultsRequest request, final AsyncHandler<GetQueryResultsRequest, GetQueryResultsResult> asyncHandler) {
        final GetQueryResultsRequest finalRequest = (GetQueryResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryResultsResult>(){

            @Override
            public GetQueryResultsResult call() throws Exception {
                GetQueryResultsResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeGetQueryResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryStatusResult> getQueryStatusAsync(GetQueryStatusRequest request) {
        return this.getQueryStatusAsync(request, null);
    }

    @Override
    public Future<GetQueryStatusResult> getQueryStatusAsync(GetQueryStatusRequest request, final AsyncHandler<GetQueryStatusRequest, GetQueryStatusResult> asyncHandler) {
        final GetQueryStatusRequest finalRequest = (GetQueryStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryStatusResult>(){

            @Override
            public GetQueryStatusResult call() throws Exception {
                GetQueryStatusResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeGetQueryStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHealthEventsResult> listHealthEventsAsync(ListHealthEventsRequest request) {
        return this.listHealthEventsAsync(request, null);
    }

    @Override
    public Future<ListHealthEventsResult> listHealthEventsAsync(ListHealthEventsRequest request, final AsyncHandler<ListHealthEventsRequest, ListHealthEventsResult> asyncHandler) {
        final ListHealthEventsRequest finalRequest = (ListHealthEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHealthEventsResult>(){

            @Override
            public ListHealthEventsResult call() throws Exception {
                ListHealthEventsResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeListHealthEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInternetEventsResult> listInternetEventsAsync(ListInternetEventsRequest request) {
        return this.listInternetEventsAsync(request, null);
    }

    @Override
    public Future<ListInternetEventsResult> listInternetEventsAsync(ListInternetEventsRequest request, final AsyncHandler<ListInternetEventsRequest, ListInternetEventsResult> asyncHandler) {
        final ListInternetEventsRequest finalRequest = (ListInternetEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInternetEventsResult>(){

            @Override
            public ListInternetEventsResult call() throws Exception {
                ListInternetEventsResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeListInternetEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request) {
        return this.listMonitorsAsync(request, null);
    }

    @Override
    public Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request, final AsyncHandler<ListMonitorsRequest, ListMonitorsResult> asyncHandler) {
        final ListMonitorsRequest finalRequest = (ListMonitorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMonitorsResult>(){

            @Override
            public ListMonitorsResult call() throws Exception {
                ListMonitorsResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeListMonitors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQueryResult> startQueryAsync(StartQueryRequest request) {
        return this.startQueryAsync(request, null);
    }

    @Override
    public Future<StartQueryResult> startQueryAsync(StartQueryRequest request, final AsyncHandler<StartQueryRequest, StartQueryResult> asyncHandler) {
        final StartQueryRequest finalRequest = (StartQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQueryResult>(){

            @Override
            public StartQueryResult call() throws Exception {
                StartQueryResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeStartQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopQueryResult> stopQueryAsync(StopQueryRequest request) {
        return this.stopQueryAsync(request, null);
    }

    @Override
    public Future<StopQueryResult> stopQueryAsync(StopQueryRequest request, final AsyncHandler<StopQueryRequest, StopQueryResult> asyncHandler) {
        final StopQueryRequest finalRequest = (StopQueryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopQueryResult>(){

            @Override
            public StopQueryResult call() throws Exception {
                StopQueryResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeStopQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request) {
        return this.updateMonitorAsync(request, null);
    }

    @Override
    public Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request, final AsyncHandler<UpdateMonitorRequest, UpdateMonitorResult> asyncHandler) {
        final UpdateMonitorRequest finalRequest = (UpdateMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMonitorResult>(){

            @Override
            public UpdateMonitorResult call() throws Exception {
                UpdateMonitorResult result = null;
                try {
                    result = AmazonInternetMonitorAsyncClient.this.executeUpdateMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

