/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.RepositorySortBy;
import com.amazonaws.services.inspector2.model.SortOrder;
import com.amazonaws.services.inspector2.model.StringFilter;
import com.amazonaws.services.inspector2.model.transform.RepositoryAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StringFilter> repositories;
    private String sortBy;
    private String sortOrder;

    public List<StringFilter> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Collection<StringFilter> repositories) {
        if (repositories == null) {
            this.repositories = null;
            return;
        }
        this.repositories = new ArrayList<StringFilter>(repositories);
    }

    public RepositoryAggregation withRepositories(StringFilter ... repositories) {
        if (this.repositories == null) {
            this.setRepositories(new ArrayList<StringFilter>(repositories.length));
        }
        for (StringFilter ele : repositories) {
            this.repositories.add(ele);
        }
        return this;
    }

    public RepositoryAggregation withRepositories(Collection<StringFilter> repositories) {
        this.setRepositories(repositories);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public RepositoryAggregation withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public RepositoryAggregation withSortBy(RepositorySortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public RepositoryAggregation withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public RepositoryAggregation withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositories() != null) {
            sb.append("Repositories: ").append(this.getRepositories()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAggregation)) {
            return false;
        }
        RepositoryAggregation other = (RepositoryAggregation)obj;
        if (other.getRepositories() == null ^ this.getRepositories() == null) {
            return false;
        }
        if (other.getRepositories() != null && !other.getRepositories().equals(this.getRepositories())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositories() == null ? 0 : this.getRepositories().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public RepositoryAggregation clone() {
        try {
            return (RepositoryAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

