/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.AmiSortBy;
import com.amazonaws.services.inspector2.model.SortOrder;
import com.amazonaws.services.inspector2.model.StringFilter;
import com.amazonaws.services.inspector2.model.transform.AmiAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AmiAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StringFilter> amis;
    private String sortBy;
    private String sortOrder;

    public List<StringFilter> getAmis() {
        return this.amis;
    }

    public void setAmis(Collection<StringFilter> amis) {
        if (amis == null) {
            this.amis = null;
            return;
        }
        this.amis = new ArrayList<StringFilter>(amis);
    }

    public AmiAggregation withAmis(StringFilter ... amis) {
        if (this.amis == null) {
            this.setAmis(new ArrayList<StringFilter>(amis.length));
        }
        for (StringFilter ele : amis) {
            this.amis.add(ele);
        }
        return this;
    }

    public AmiAggregation withAmis(Collection<StringFilter> amis) {
        this.setAmis(amis);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public AmiAggregation withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public AmiAggregation withSortBy(AmiSortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public AmiAggregation withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public AmiAggregation withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmis() != null) {
            sb.append("Amis: ").append(this.getAmis()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiAggregation)) {
            return false;
        }
        AmiAggregation other = (AmiAggregation)obj;
        if (other.getAmis() == null ^ this.getAmis() == null) {
            return false;
        }
        if (other.getAmis() != null && !other.getAmis().equals(this.getAmis())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmis() == null ? 0 : this.getAmis().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public AmiAggregation clone() {
        try {
            return (AmiAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AmiAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

