/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Finding;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class FindingMarshaller {
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccountId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> FINDINGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("findingArn").build();
    private static final MarshallingInfo<Date> FIRSTOBSERVEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstObservedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Double> INSPECTORSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inspectorScore").build();
    private static final MarshallingInfo<StructuredPojo> INSPECTORSCOREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inspectorScoreDetails").build();
    private static final MarshallingInfo<Date> LASTOBSERVEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastObservedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKREACHABILITYDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkReachabilityDetails").build();
    private static final MarshallingInfo<StructuredPojo> PACKAGEVULNERABILITYDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageVulnerabilityDetails").build();
    private static final MarshallingInfo<StructuredPojo> REMEDIATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remediation").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resources").build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severity").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").timestampFormat("unixTimestamp").build();
    private static final FindingMarshaller instance = new FindingMarshaller();

    public static FindingMarshaller getInstance() {
        return instance;
    }

    public void marshall(Finding finding, ProtocolMarshaller protocolMarshaller) {
        if (finding == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)finding.getAwsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)finding.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)finding.getFindingArn(), FINDINGARN_BINDING);
            protocolMarshaller.marshall((Object)finding.getFirstObservedAt(), FIRSTOBSERVEDAT_BINDING);
            protocolMarshaller.marshall((Object)finding.getInspectorScore(), INSPECTORSCORE_BINDING);
            protocolMarshaller.marshall((Object)finding.getInspectorScoreDetails(), INSPECTORSCOREDETAILS_BINDING);
            protocolMarshaller.marshall((Object)finding.getLastObservedAt(), LASTOBSERVEDAT_BINDING);
            protocolMarshaller.marshall((Object)finding.getNetworkReachabilityDetails(), NETWORKREACHABILITYDETAILS_BINDING);
            protocolMarshaller.marshall((Object)finding.getPackageVulnerabilityDetails(), PACKAGEVULNERABILITYDETAILS_BINDING);
            protocolMarshaller.marshall((Object)finding.getRemediation(), REMEDIATION_BINDING);
            protocolMarshaller.marshall(finding.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)finding.getSeverity(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)finding.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)finding.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)finding.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)finding.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

