/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.imagebuilder.model.ComponentVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListComponentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String requestId;
    private List<ComponentVersion> componentVersionList;
    private String nextToken;

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ListComponentsResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public List<ComponentVersion> getComponentVersionList() {
        return this.componentVersionList;
    }

    public void setComponentVersionList(Collection<ComponentVersion> componentVersionList) {
        if (componentVersionList == null) {
            this.componentVersionList = null;
            return;
        }
        this.componentVersionList = new ArrayList<ComponentVersion>(componentVersionList);
    }

    public ListComponentsResult withComponentVersionList(ComponentVersion ... componentVersionList) {
        if (this.componentVersionList == null) {
            this.setComponentVersionList(new ArrayList<ComponentVersion>(componentVersionList.length));
        }
        for (ComponentVersion ele : componentVersionList) {
            this.componentVersionList.add(ele);
        }
        return this;
    }

    public ListComponentsResult withComponentVersionList(Collection<ComponentVersion> componentVersionList) {
        this.setComponentVersionList(componentVersionList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListComponentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getComponentVersionList() != null) {
            sb.append("ComponentVersionList: ").append(this.getComponentVersionList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResult)) {
            return false;
        }
        ListComponentsResult other = (ListComponentsResult)obj;
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getComponentVersionList() == null ^ this.getComponentVersionList() == null) {
            return false;
        }
        if (other.getComponentVersionList() != null && !other.getComponentVersionList().equals(this.getComponentVersionList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentVersionList() == null ? 0 : this.getComponentVersionList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListComponentsResult clone() {
        try {
            return (ListComponentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

