/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.ComponentParameter;
import com.amazonaws.services.imagebuilder.model.transform.ComponentConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentArn;
    private List<ComponentParameter> parameters;

    public void setComponentArn(String componentArn) {
        this.componentArn = componentArn;
    }

    public String getComponentArn() {
        return this.componentArn;
    }

    public ComponentConfiguration withComponentArn(String componentArn) {
        this.setComponentArn(componentArn);
        return this;
    }

    public List<ComponentParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ComponentParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<ComponentParameter>(parameters);
    }

    public ComponentConfiguration withParameters(ComponentParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<ComponentParameter>(parameters.length));
        }
        for (ComponentParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ComponentConfiguration withParameters(Collection<ComponentParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentArn() != null) {
            sb.append("ComponentArn: ").append(this.getComponentArn()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        ComponentConfiguration other = (ComponentConfiguration)obj;
        if (other.getComponentArn() == null ^ this.getComponentArn() == null) {
            return false;
        }
        if (other.getComponentArn() != null && !other.getComponentArn().equals(this.getComponentArn())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentArn() == null ? 0 : this.getComponentArn().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ComponentConfiguration clone() {
        try {
            return (ComponentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

