/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest;
import com.amazonaws.services.identitymanagement.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSAMLProviderRequestMarshaller
implements Marshaller<Request<CreateSAMLProviderRequest>, CreateSAMLProviderRequest> {
    public Request<CreateSAMLProviderRequest> marshall(CreateSAMLProviderRequest createSAMLProviderRequest) {
        if (createSAMLProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSAMLProviderRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSAMLProviderRequest.getSAMLMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringUtils.fromString((String)createSAMLProviderRequest.getSAMLMetadataDocument()));
        }
        if (createSAMLProviderRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createSAMLProviderRequest.getName()));
        }
        if (!createSAMLProviderRequest.getTags().isEmpty() || !((SdkInternalList)createSAMLProviderRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createSAMLProviderRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

