/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.Container;
import java.util.List;

@SdkInternalApi
public class ContainerMarshaller {
    private static final MarshallingInfo<String> CONTAINERRUNTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerRuntime").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<String> IMAGEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePrefix").build();
    private static final MarshallingInfo<List> VOLUMEMOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumeMounts").build();
    private static final MarshallingInfo<StructuredPojo> SECURITYCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityContext").build();
    private static final ContainerMarshaller instance = new ContainerMarshaller();

    public static ContainerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Container container, ProtocolMarshaller protocolMarshaller) {
        if (container == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)container.getContainerRuntime(), CONTAINERRUNTIME_BINDING);
            protocolMarshaller.marshall((Object)container.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)container.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)container.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)container.getImagePrefix(), IMAGEPREFIX_BINDING);
            protocolMarshaller.marshall(container.getVolumeMounts(), VOLUMEMOUNTS_BINDING);
            protocolMarshaller.marshall((Object)container.getSecurityContext(), SECURITYCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

