/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.Action;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<String> ACTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionType").build();
    private static final MarshallingInfo<StructuredPojo> AWSAPICALLACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsApiCallAction").build();
    private static final MarshallingInfo<StructuredPojo> DNSREQUESTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsRequestAction").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONNECTIONACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkConnectionAction").build();
    private static final MarshallingInfo<StructuredPojo> PORTPROBEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("portProbeAction").build();
    private static final MarshallingInfo<StructuredPojo> KUBERNETESAPICALLACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesApiCallAction").build();
    private static final MarshallingInfo<StructuredPojo> RDSLOGINATTEMPTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rdsLoginAttemptAction").build();
    private static final MarshallingInfo<StructuredPojo> KUBERNETESPERMISSIONCHECKEDDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesPermissionCheckedDetails").build();
    private static final MarshallingInfo<StructuredPojo> KUBERNETESROLEBINDINGDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesRoleBindingDetails").build();
    private static final MarshallingInfo<StructuredPojo> KUBERNETESROLEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesRoleDetails").build();
    private static final ActionMarshaller instance = new ActionMarshaller();

    public static ActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        if (action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)action.getActionType(), ACTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)action.getAwsApiCallAction(), AWSAPICALLACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getDnsRequestAction(), DNSREQUESTACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getNetworkConnectionAction(), NETWORKCONNECTIONACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getPortProbeAction(), PORTPROBEACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getKubernetesApiCallAction(), KUBERNETESAPICALLACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getRdsLoginAttemptAction(), RDSLOGINATTEMPTACTION_BINDING);
            protocolMarshaller.marshall((Object)action.getKubernetesPermissionCheckedDetails(), KUBERNETESPERMISSIONCHECKEDDETAILS_BINDING);
            protocolMarshaller.marshall((Object)action.getKubernetesRoleBindingDetails(), KUBERNETESROLEBINDINGDETAILS_BINDING);
            protocolMarshaller.marshall((Object)action.getKubernetesRoleDetails(), KUBERNETESROLEDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

