/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.AllowedStatistics;
import com.amazonaws.services.gluedatabrew.model.transform.EntityDetectorConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityDetectorConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> entityTypes;
    private List<AllowedStatistics> allowedStatistics;

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<String> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<String>(entityTypes);
    }

    public EntityDetectorConfiguration withEntityTypes(String ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<String>(entityTypes.length));
        }
        for (String ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public EntityDetectorConfiguration withEntityTypes(Collection<String> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public List<AllowedStatistics> getAllowedStatistics() {
        return this.allowedStatistics;
    }

    public void setAllowedStatistics(Collection<AllowedStatistics> allowedStatistics) {
        if (allowedStatistics == null) {
            this.allowedStatistics = null;
            return;
        }
        this.allowedStatistics = new ArrayList<AllowedStatistics>(allowedStatistics);
    }

    public EntityDetectorConfiguration withAllowedStatistics(AllowedStatistics ... allowedStatistics) {
        if (this.allowedStatistics == null) {
            this.setAllowedStatistics(new ArrayList<AllowedStatistics>(allowedStatistics.length));
        }
        for (AllowedStatistics ele : allowedStatistics) {
            this.allowedStatistics.add(ele);
        }
        return this;
    }

    public EntityDetectorConfiguration withAllowedStatistics(Collection<AllowedStatistics> allowedStatistics) {
        this.setAllowedStatistics(allowedStatistics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes()).append(",");
        }
        if (this.getAllowedStatistics() != null) {
            sb.append("AllowedStatistics: ").append(this.getAllowedStatistics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetectorConfiguration)) {
            return false;
        }
        EntityDetectorConfiguration other = (EntityDetectorConfiguration)obj;
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        if (other.getEntityTypes() != null && !other.getEntityTypes().equals(this.getEntityTypes())) {
            return false;
        }
        if (other.getAllowedStatistics() == null ^ this.getAllowedStatistics() == null) {
            return false;
        }
        return other.getAllowedStatistics() == null || other.getAllowedStatistics().equals(this.getAllowedStatistics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedStatistics() == null ? 0 : this.getAllowedStatistics().hashCode());
        return hashCode;
    }

    public EntityDetectorConfiguration clone() {
        try {
            return (EntityDetectorConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityDetectorConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

