/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.ColumnSelector;
import com.amazonaws.services.gluedatabrew.model.Threshold;
import com.amazonaws.services.gluedatabrew.model.transform.RuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rule
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Boolean disabled;
    private String checkExpression;
    private Map<String, String> substitutionMap;
    private Threshold threshold;
    private List<ColumnSelector> columnSelectors;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Rule withDisabled(Boolean disabled) {
        this.setDisabled(disabled);
        return this;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setCheckExpression(String checkExpression) {
        this.checkExpression = checkExpression;
    }

    public String getCheckExpression() {
        return this.checkExpression;
    }

    public Rule withCheckExpression(String checkExpression) {
        this.setCheckExpression(checkExpression);
        return this;
    }

    public Map<String, String> getSubstitutionMap() {
        return this.substitutionMap;
    }

    public void setSubstitutionMap(Map<String, String> substitutionMap) {
        this.substitutionMap = substitutionMap;
    }

    public Rule withSubstitutionMap(Map<String, String> substitutionMap) {
        this.setSubstitutionMap(substitutionMap);
        return this;
    }

    public Rule addSubstitutionMapEntry(String key, String value) {
        if (null == this.substitutionMap) {
            this.substitutionMap = new HashMap<String, String>();
        }
        if (this.substitutionMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutionMap.put(key, value);
        return this;
    }

    public Rule clearSubstitutionMapEntries() {
        this.substitutionMap = null;
        return this;
    }

    public void setThreshold(Threshold threshold) {
        this.threshold = threshold;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    public Rule withThreshold(Threshold threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public List<ColumnSelector> getColumnSelectors() {
        return this.columnSelectors;
    }

    public void setColumnSelectors(Collection<ColumnSelector> columnSelectors) {
        if (columnSelectors == null) {
            this.columnSelectors = null;
            return;
        }
        this.columnSelectors = new ArrayList<ColumnSelector>(columnSelectors);
    }

    public Rule withColumnSelectors(ColumnSelector ... columnSelectors) {
        if (this.columnSelectors == null) {
            this.setColumnSelectors(new ArrayList<ColumnSelector>(columnSelectors.length));
        }
        for (ColumnSelector ele : columnSelectors) {
            this.columnSelectors.add(ele);
        }
        return this;
    }

    public Rule withColumnSelectors(Collection<ColumnSelector> columnSelectors) {
        this.setColumnSelectors(columnSelectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDisabled() != null) {
            sb.append("Disabled: ").append(this.getDisabled()).append(",");
        }
        if (this.getCheckExpression() != null) {
            sb.append("CheckExpression: ").append(this.getCheckExpression()).append(",");
        }
        if (this.getSubstitutionMap() != null) {
            sb.append("SubstitutionMap: ").append(this.getSubstitutionMap()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold()).append(",");
        }
        if (this.getColumnSelectors() != null) {
            sb.append("ColumnSelectors: ").append(this.getColumnSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDisabled() == null ^ this.getDisabled() == null) {
            return false;
        }
        if (other.getDisabled() != null && !other.getDisabled().equals(this.getDisabled())) {
            return false;
        }
        if (other.getCheckExpression() == null ^ this.getCheckExpression() == null) {
            return false;
        }
        if (other.getCheckExpression() != null && !other.getCheckExpression().equals(this.getCheckExpression())) {
            return false;
        }
        if (other.getSubstitutionMap() == null ^ this.getSubstitutionMap() == null) {
            return false;
        }
        if (other.getSubstitutionMap() != null && !other.getSubstitutionMap().equals(this.getSubstitutionMap())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getColumnSelectors() == null ^ this.getColumnSelectors() == null) {
            return false;
        }
        return other.getColumnSelectors() == null || other.getColumnSelectors().equals(this.getColumnSelectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDisabled() == null ? 0 : this.getDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getCheckExpression() == null ? 0 : this.getCheckExpression().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutionMap() == null ? 0 : this.getSubstitutionMap().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getColumnSelectors() == null ? 0 : this.getColumnSelectors().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

