/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gluedatabrew.model.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRulesetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<Rule> rules;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateRulesetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateRulesetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public UpdateRulesetRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public UpdateRulesetRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRulesetRequest)) {
            return false;
        }
        UpdateRulesetRequest other = (UpdateRulesetRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public UpdateRulesetRequest clone() {
        return (UpdateRulesetRequest)super.clone();
    }
}

