/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gluedatabrew.model.Recipe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecipeVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Recipe> recipes;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecipeVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Recipe> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(Collection<Recipe> recipes) {
        if (recipes == null) {
            this.recipes = null;
            return;
        }
        this.recipes = new ArrayList<Recipe>(recipes);
    }

    public ListRecipeVersionsResult withRecipes(Recipe ... recipes) {
        if (this.recipes == null) {
            this.setRecipes(new ArrayList<Recipe>(recipes.length));
        }
        for (Recipe ele : recipes) {
            this.recipes.add(ele);
        }
        return this;
    }

    public ListRecipeVersionsResult withRecipes(Collection<Recipe> recipes) {
        this.setRecipes(recipes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRecipes() != null) {
            sb.append("Recipes: ").append(this.getRecipes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipeVersionsResult)) {
            return false;
        }
        ListRecipeVersionsResult other = (ListRecipeVersionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRecipes() == null ^ this.getRecipes() == null) {
            return false;
        }
        return other.getRecipes() == null || other.getRecipes().equals(this.getRecipes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRecipes() == null ? 0 : this.getRecipes().hashCode());
        return hashCode;
    }

    public ListRecipeVersionsResult clone() {
        try {
            return (ListRecipeVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

