/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateScheduleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> jobNames;
    private String cronExpression;
    private Map<String, String> tags;
    private String name;

    public List<String> getJobNames() {
        return this.jobNames;
    }

    public void setJobNames(Collection<String> jobNames) {
        if (jobNames == null) {
            this.jobNames = null;
            return;
        }
        this.jobNames = new ArrayList<String>(jobNames);
    }

    public CreateScheduleRequest withJobNames(String ... jobNames) {
        if (this.jobNames == null) {
            this.setJobNames(new ArrayList<String>(jobNames.length));
        }
        for (String ele : jobNames) {
            this.jobNames.add(ele);
        }
        return this;
    }

    public CreateScheduleRequest withJobNames(Collection<String> jobNames) {
        this.setJobNames(jobNames);
        return this;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public CreateScheduleRequest withCronExpression(String cronExpression) {
        this.setCronExpression(cronExpression);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateScheduleRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateScheduleRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateScheduleRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateScheduleRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobNames() != null) {
            sb.append("JobNames: ").append(this.getJobNames()).append(",");
        }
        if (this.getCronExpression() != null) {
            sb.append("CronExpression: ").append(this.getCronExpression()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleRequest)) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest)obj;
        if (other.getJobNames() == null ^ this.getJobNames() == null) {
            return false;
        }
        if (other.getJobNames() != null && !other.getJobNames().equals(this.getJobNames())) {
            return false;
        }
        if (other.getCronExpression() == null ^ this.getCronExpression() == null) {
            return false;
        }
        if (other.getCronExpression() != null && !other.getCronExpression().equals(this.getCronExpression())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobNames() == null ? 0 : this.getJobNames().hashCode());
        hashCode = 31 * hashCode + (this.getCronExpression() == null ? 0 : this.getCronExpression().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public CreateScheduleRequest clone() {
        return (CreateScheduleRequest)super.clone();
    }
}

