/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glue.model.Workflow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetWorkflowsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Workflow> workflows;
    private List<String> missingWorkflows;

    public List<Workflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Collection<Workflow> workflows) {
        if (workflows == null) {
            this.workflows = null;
            return;
        }
        this.workflows = new ArrayList<Workflow>(workflows);
    }

    public BatchGetWorkflowsResult withWorkflows(Workflow ... workflows) {
        if (this.workflows == null) {
            this.setWorkflows(new ArrayList<Workflow>(workflows.length));
        }
        for (Workflow ele : workflows) {
            this.workflows.add(ele);
        }
        return this;
    }

    public BatchGetWorkflowsResult withWorkflows(Collection<Workflow> workflows) {
        this.setWorkflows(workflows);
        return this;
    }

    public List<String> getMissingWorkflows() {
        return this.missingWorkflows;
    }

    public void setMissingWorkflows(Collection<String> missingWorkflows) {
        if (missingWorkflows == null) {
            this.missingWorkflows = null;
            return;
        }
        this.missingWorkflows = new ArrayList<String>(missingWorkflows);
    }

    public BatchGetWorkflowsResult withMissingWorkflows(String ... missingWorkflows) {
        if (this.missingWorkflows == null) {
            this.setMissingWorkflows(new ArrayList<String>(missingWorkflows.length));
        }
        for (String ele : missingWorkflows) {
            this.missingWorkflows.add(ele);
        }
        return this;
    }

    public BatchGetWorkflowsResult withMissingWorkflows(Collection<String> missingWorkflows) {
        this.setMissingWorkflows(missingWorkflows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkflows() != null) {
            sb.append("Workflows: ").append(this.getWorkflows()).append(",");
        }
        if (this.getMissingWorkflows() != null) {
            sb.append("MissingWorkflows: ").append(this.getMissingWorkflows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetWorkflowsResult)) {
            return false;
        }
        BatchGetWorkflowsResult other = (BatchGetWorkflowsResult)obj;
        if (other.getWorkflows() == null ^ this.getWorkflows() == null) {
            return false;
        }
        if (other.getWorkflows() != null && !other.getWorkflows().equals(this.getWorkflows())) {
            return false;
        }
        if (other.getMissingWorkflows() == null ^ this.getMissingWorkflows() == null) {
            return false;
        }
        return other.getMissingWorkflows() == null || other.getMissingWorkflows().equals(this.getMissingWorkflows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkflows() == null ? 0 : this.getWorkflows().hashCode());
        hashCode = 31 * hashCode + (this.getMissingWorkflows() == null ? 0 : this.getMissingWorkflows().hashCode());
        return hashCode;
    }

    public BatchGetWorkflowsResult clone() {
        try {
            return (BatchGetWorkflowsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

