/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamelift.model.Script;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListScriptsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Script> scripts;
    private String nextToken;

    public List<Script> getScripts() {
        return this.scripts;
    }

    public void setScripts(Collection<Script> scripts) {
        if (scripts == null) {
            this.scripts = null;
            return;
        }
        this.scripts = new ArrayList<Script>(scripts);
    }

    public ListScriptsResult withScripts(Script ... scripts) {
        if (this.scripts == null) {
            this.setScripts(new ArrayList<Script>(scripts.length));
        }
        for (Script ele : scripts) {
            this.scripts.add(ele);
        }
        return this;
    }

    public ListScriptsResult withScripts(Collection<Script> scripts) {
        this.setScripts(scripts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListScriptsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScripts() != null) {
            sb.append("Scripts: ").append(this.getScripts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScriptsResult)) {
            return false;
        }
        ListScriptsResult other = (ListScriptsResult)obj;
        if (other.getScripts() == null ^ this.getScripts() == null) {
            return false;
        }
        if (other.getScripts() != null && !other.getScripts().equals(this.getScripts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScripts() == null ? 0 : this.getScripts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListScriptsResult clone() {
        try {
            return (ListScriptsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

