/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreateGameSessionRequest;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.transform.GamePropertyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateGameSessionRequestMarshaller
implements Marshaller<Request<CreateGameSessionRequest>, CreateGameSessionRequest> {
    public Request<CreateGameSessionRequest> marshall(CreateGameSessionRequest createGameSessionRequest) {
        if (createGameSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GameProperty> gamePropertiesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createGameSessionRequest.getFleetId() != null) {
                jsonWriter.key("FleetId").value((Object)createGameSessionRequest.getFleetId());
            }
            if (createGameSessionRequest.getAliasId() != null) {
                jsonWriter.key("AliasId").value((Object)createGameSessionRequest.getAliasId());
            }
            if (createGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonWriter.key("MaximumPlayerSessionCount").value((Object)createGameSessionRequest.getMaximumPlayerSessionCount());
            }
            if (createGameSessionRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createGameSessionRequest.getName());
            }
            if ((gamePropertiesList = createGameSessionRequest.getGameProperties()) != null) {
                jsonWriter.key("GameProperties");
                jsonWriter.array();
                for (GameProperty gamePropertiesListValue : gamePropertiesList) {
                    if (gamePropertiesListValue == null) continue;
                    GamePropertyJsonMarshaller.getInstance().marshall(gamePropertiesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

