/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.transform.AttributeConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AttributeConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String attributeName;
    private Map<String, String> transformations;

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeConfig withAttributeName(String attributeName) {
        this.setAttributeName(attributeName);
        return this;
    }

    public Map<String, String> getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Map<String, String> transformations) {
        this.transformations = transformations;
    }

    public AttributeConfig withTransformations(Map<String, String> transformations) {
        this.setTransformations(transformations);
        return this;
    }

    public AttributeConfig addTransformationsEntry(String key, String value) {
        if (null == this.transformations) {
            this.transformations = new HashMap<String, String>();
        }
        if (this.transformations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.transformations.put(key, value);
        return this;
    }

    public AttributeConfig clearTransformationsEntries() {
        this.transformations = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeName() != null) {
            sb.append("AttributeName: ").append(this.getAttributeName()).append(",");
        }
        if (this.getTransformations() != null) {
            sb.append("Transformations: ").append(this.getTransformations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeConfig)) {
            return false;
        }
        AttributeConfig other = (AttributeConfig)obj;
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) {
            return false;
        }
        if (other.getAttributeName() != null && !other.getAttributeName().equals(this.getAttributeName())) {
            return false;
        }
        if (other.getTransformations() == null ^ this.getTransformations() == null) {
            return false;
        }
        return other.getTransformations() == null || other.getTransformations().equals(this.getTransformations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getTransformations() == null ? 0 : this.getTransformations().hashCode());
        return hashCode;
    }

    public AttributeConfig clone() {
        try {
            return (AttributeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

