/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.DatasetSummary;
import java.util.Date;

@SdkInternalApi
public class DatasetSummaryMarshaller {
    private static final MarshallingInfo<String> DATASETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetArn").build();
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetName").build();
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetType").build();
    private static final MarshallingInfo<String> DOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domain").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFICATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModificationTime").timestampFormat("unixTimestamp").build();
    private static final DatasetSummaryMarshaller instance = new DatasetSummaryMarshaller();

    public static DatasetSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetSummary datasetSummary, ProtocolMarshaller protocolMarshaller) {
        if (datasetSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datasetSummary.getDatasetArn(), DATASETARN_BINDING);
            protocolMarshaller.marshall((Object)datasetSummary.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)datasetSummary.getDatasetType(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall((Object)datasetSummary.getDomain(), DOMAIN_BINDING);
            protocolMarshaller.marshall((Object)datasetSummary.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)datasetSummary.getLastModificationTime(), LASTMODIFICATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

