/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.RemediationActionWithOrder;
import com.amazonaws.services.fms.model.transform.PossibleRemediationActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PossibleRemediationAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<RemediationActionWithOrder> orderedRemediationActions;
    private Boolean isDefaultAction;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public PossibleRemediationAction withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<RemediationActionWithOrder> getOrderedRemediationActions() {
        return this.orderedRemediationActions;
    }

    public void setOrderedRemediationActions(Collection<RemediationActionWithOrder> orderedRemediationActions) {
        if (orderedRemediationActions == null) {
            this.orderedRemediationActions = null;
            return;
        }
        this.orderedRemediationActions = new ArrayList<RemediationActionWithOrder>(orderedRemediationActions);
    }

    public PossibleRemediationAction withOrderedRemediationActions(RemediationActionWithOrder ... orderedRemediationActions) {
        if (this.orderedRemediationActions == null) {
            this.setOrderedRemediationActions(new ArrayList<RemediationActionWithOrder>(orderedRemediationActions.length));
        }
        for (RemediationActionWithOrder ele : orderedRemediationActions) {
            this.orderedRemediationActions.add(ele);
        }
        return this;
    }

    public PossibleRemediationAction withOrderedRemediationActions(Collection<RemediationActionWithOrder> orderedRemediationActions) {
        this.setOrderedRemediationActions(orderedRemediationActions);
        return this;
    }

    public void setIsDefaultAction(Boolean isDefaultAction) {
        this.isDefaultAction = isDefaultAction;
    }

    public Boolean getIsDefaultAction() {
        return this.isDefaultAction;
    }

    public PossibleRemediationAction withIsDefaultAction(Boolean isDefaultAction) {
        this.setIsDefaultAction(isDefaultAction);
        return this;
    }

    public Boolean isDefaultAction() {
        return this.isDefaultAction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOrderedRemediationActions() != null) {
            sb.append("OrderedRemediationActions: ").append(this.getOrderedRemediationActions()).append(",");
        }
        if (this.getIsDefaultAction() != null) {
            sb.append("IsDefaultAction: ").append(this.getIsDefaultAction());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PossibleRemediationAction)) {
            return false;
        }
        PossibleRemediationAction other = (PossibleRemediationAction)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOrderedRemediationActions() == null ^ this.getOrderedRemediationActions() == null) {
            return false;
        }
        if (other.getOrderedRemediationActions() != null && !other.getOrderedRemediationActions().equals(this.getOrderedRemediationActions())) {
            return false;
        }
        if (other.getIsDefaultAction() == null ^ this.getIsDefaultAction() == null) {
            return false;
        }
        return other.getIsDefaultAction() == null || other.getIsDefaultAction().equals(this.getIsDefaultAction());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOrderedRemediationActions() == null ? 0 : this.getOrderedRemediationActions().hashCode());
        hashCode = 31 * hashCode + (this.getIsDefaultAction() == null ? 0 : this.getIsDefaultAction().hashCode());
        return hashCode;
    }

    public PossibleRemediationAction clone() {
        try {
            return (PossibleRemediationAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PossibleRemediationActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

