/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchAssociateResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceSetIdentifier;
    private List<String> items;

    public void setResourceSetIdentifier(String resourceSetIdentifier) {
        this.resourceSetIdentifier = resourceSetIdentifier;
    }

    public String getResourceSetIdentifier() {
        return this.resourceSetIdentifier;
    }

    public BatchAssociateResourceRequest withResourceSetIdentifier(String resourceSetIdentifier) {
        this.setResourceSetIdentifier(resourceSetIdentifier);
        return this;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<String>(items);
    }

    public BatchAssociateResourceRequest withItems(String ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<String>(items.length));
        }
        for (String ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public BatchAssociateResourceRequest withItems(Collection<String> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSetIdentifier() != null) {
            sb.append("ResourceSetIdentifier: ").append(this.getResourceSetIdentifier()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourceRequest)) {
            return false;
        }
        BatchAssociateResourceRequest other = (BatchAssociateResourceRequest)obj;
        if (other.getResourceSetIdentifier() == null ^ this.getResourceSetIdentifier() == null) {
            return false;
        }
        if (other.getResourceSetIdentifier() != null && !other.getResourceSetIdentifier().equals(this.getResourceSetIdentifier())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSetIdentifier() == null ? 0 : this.getResourceSetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public BatchAssociateResourceRequest clone() {
        return (BatchAssociateResourceRequest)super.clone();
    }
}

