/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.transform.ExperimentTargetFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExperimentTargetFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private List<String> values;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public ExperimentTargetFilter withPath(String path) {
        this.setPath(path);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public ExperimentTargetFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public ExperimentTargetFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTargetFilter)) {
            return false;
        }
        ExperimentTargetFilter other = (ExperimentTargetFilter)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public ExperimentTargetFilter clone() {
        try {
            return (ExperimentTargetFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentTargetFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

