/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsync;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsyncClientBuilder;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataClient;
import com.amazonaws.services.finspacedata.model.AssociateUserToPermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.AssociateUserToPermissionGroupResult;
import com.amazonaws.services.finspacedata.model.CreateChangesetRequest;
import com.amazonaws.services.finspacedata.model.CreateChangesetResult;
import com.amazonaws.services.finspacedata.model.CreateDataViewRequest;
import com.amazonaws.services.finspacedata.model.CreateDataViewResult;
import com.amazonaws.services.finspacedata.model.CreateDatasetRequest;
import com.amazonaws.services.finspacedata.model.CreateDatasetResult;
import com.amazonaws.services.finspacedata.model.CreatePermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.CreatePermissionGroupResult;
import com.amazonaws.services.finspacedata.model.CreateUserRequest;
import com.amazonaws.services.finspacedata.model.CreateUserResult;
import com.amazonaws.services.finspacedata.model.DeleteDatasetRequest;
import com.amazonaws.services.finspacedata.model.DeleteDatasetResult;
import com.amazonaws.services.finspacedata.model.DeletePermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.DeletePermissionGroupResult;
import com.amazonaws.services.finspacedata.model.DisableUserRequest;
import com.amazonaws.services.finspacedata.model.DisableUserResult;
import com.amazonaws.services.finspacedata.model.DisassociateUserFromPermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.DisassociateUserFromPermissionGroupResult;
import com.amazonaws.services.finspacedata.model.EnableUserRequest;
import com.amazonaws.services.finspacedata.model.EnableUserResult;
import com.amazonaws.services.finspacedata.model.GetChangesetRequest;
import com.amazonaws.services.finspacedata.model.GetChangesetResult;
import com.amazonaws.services.finspacedata.model.GetDataViewRequest;
import com.amazonaws.services.finspacedata.model.GetDataViewResult;
import com.amazonaws.services.finspacedata.model.GetDatasetRequest;
import com.amazonaws.services.finspacedata.model.GetDatasetResult;
import com.amazonaws.services.finspacedata.model.GetPermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.GetPermissionGroupResult;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsResult;
import com.amazonaws.services.finspacedata.model.GetUserRequest;
import com.amazonaws.services.finspacedata.model.GetUserResult;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationRequest;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationResult;
import com.amazonaws.services.finspacedata.model.ListChangesetsRequest;
import com.amazonaws.services.finspacedata.model.ListChangesetsResult;
import com.amazonaws.services.finspacedata.model.ListDataViewsRequest;
import com.amazonaws.services.finspacedata.model.ListDataViewsResult;
import com.amazonaws.services.finspacedata.model.ListDatasetsRequest;
import com.amazonaws.services.finspacedata.model.ListDatasetsResult;
import com.amazonaws.services.finspacedata.model.ListPermissionGroupsByUserRequest;
import com.amazonaws.services.finspacedata.model.ListPermissionGroupsByUserResult;
import com.amazonaws.services.finspacedata.model.ListPermissionGroupsRequest;
import com.amazonaws.services.finspacedata.model.ListPermissionGroupsResult;
import com.amazonaws.services.finspacedata.model.ListUsersByPermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.ListUsersByPermissionGroupResult;
import com.amazonaws.services.finspacedata.model.ListUsersRequest;
import com.amazonaws.services.finspacedata.model.ListUsersResult;
import com.amazonaws.services.finspacedata.model.ResetUserPasswordRequest;
import com.amazonaws.services.finspacedata.model.ResetUserPasswordResult;
import com.amazonaws.services.finspacedata.model.UpdateChangesetRequest;
import com.amazonaws.services.finspacedata.model.UpdateChangesetResult;
import com.amazonaws.services.finspacedata.model.UpdateDatasetRequest;
import com.amazonaws.services.finspacedata.model.UpdateDatasetResult;
import com.amazonaws.services.finspacedata.model.UpdatePermissionGroupRequest;
import com.amazonaws.services.finspacedata.model.UpdatePermissionGroupResult;
import com.amazonaws.services.finspacedata.model.UpdateUserRequest;
import com.amazonaws.services.finspacedata.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFinSpaceDataAsyncClient
extends AWSFinSpaceDataClient
implements AWSFinSpaceDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFinSpaceDataAsyncClientBuilder asyncBuilder() {
        return AWSFinSpaceDataAsyncClientBuilder.standard();
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateUserToPermissionGroupResult> associateUserToPermissionGroupAsync(AssociateUserToPermissionGroupRequest request) {
        return this.associateUserToPermissionGroupAsync(request, null);
    }

    @Override
    public Future<AssociateUserToPermissionGroupResult> associateUserToPermissionGroupAsync(AssociateUserToPermissionGroupRequest request, final AsyncHandler<AssociateUserToPermissionGroupRequest, AssociateUserToPermissionGroupResult> asyncHandler) {
        final AssociateUserToPermissionGroupRequest finalRequest = (AssociateUserToPermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateUserToPermissionGroupResult>(){

            @Override
            public AssociateUserToPermissionGroupResult call() throws Exception {
                AssociateUserToPermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeAssociateUserToPermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request) {
        return this.createChangesetAsync(request, null);
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request, final AsyncHandler<CreateChangesetRequest, CreateChangesetResult> asyncHandler) {
        final CreateChangesetRequest finalRequest = (CreateChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChangesetResult>(){

            @Override
            public CreateChangesetResult call() throws Exception {
                CreateChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataViewResult> createDataViewAsync(CreateDataViewRequest request) {
        return this.createDataViewAsync(request, null);
    }

    @Override
    public Future<CreateDataViewResult> createDataViewAsync(CreateDataViewRequest request, final AsyncHandler<CreateDataViewRequest, CreateDataViewResult> asyncHandler) {
        final CreateDataViewRequest finalRequest = (CreateDataViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataViewResult>(){

            @Override
            public CreateDataViewResult call() throws Exception {
                CreateDataViewResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateDataView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetAsync(request, null);
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request, final AsyncHandler<CreateDatasetRequest, CreateDatasetResult> asyncHandler) {
        final CreateDatasetRequest finalRequest = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetResult>(){

            @Override
            public CreateDatasetResult call() throws Exception {
                CreateDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePermissionGroupResult> createPermissionGroupAsync(CreatePermissionGroupRequest request) {
        return this.createPermissionGroupAsync(request, null);
    }

    @Override
    public Future<CreatePermissionGroupResult> createPermissionGroupAsync(CreatePermissionGroupRequest request, final AsyncHandler<CreatePermissionGroupRequest, CreatePermissionGroupResult> asyncHandler) {
        final CreatePermissionGroupRequest finalRequest = (CreatePermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePermissionGroupResult>(){

            @Override
            public CreatePermissionGroupResult call() throws Exception {
                CreatePermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreatePermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePermissionGroupResult> deletePermissionGroupAsync(DeletePermissionGroupRequest request) {
        return this.deletePermissionGroupAsync(request, null);
    }

    @Override
    public Future<DeletePermissionGroupResult> deletePermissionGroupAsync(DeletePermissionGroupRequest request, final AsyncHandler<DeletePermissionGroupRequest, DeletePermissionGroupResult> asyncHandler) {
        final DeletePermissionGroupRequest finalRequest = (DeletePermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePermissionGroupResult>(){

            @Override
            public DeletePermissionGroupResult call() throws Exception {
                DeletePermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeDeletePermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableUserResult> disableUserAsync(DisableUserRequest request) {
        return this.disableUserAsync(request, null);
    }

    @Override
    public Future<DisableUserResult> disableUserAsync(DisableUserRequest request, final AsyncHandler<DisableUserRequest, DisableUserResult> asyncHandler) {
        final DisableUserRequest finalRequest = (DisableUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableUserResult>(){

            @Override
            public DisableUserResult call() throws Exception {
                DisableUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeDisableUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateUserFromPermissionGroupResult> disassociateUserFromPermissionGroupAsync(DisassociateUserFromPermissionGroupRequest request) {
        return this.disassociateUserFromPermissionGroupAsync(request, null);
    }

    @Override
    public Future<DisassociateUserFromPermissionGroupResult> disassociateUserFromPermissionGroupAsync(DisassociateUserFromPermissionGroupRequest request, final AsyncHandler<DisassociateUserFromPermissionGroupRequest, DisassociateUserFromPermissionGroupResult> asyncHandler) {
        final DisassociateUserFromPermissionGroupRequest finalRequest = (DisassociateUserFromPermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateUserFromPermissionGroupResult>(){

            @Override
            public DisassociateUserFromPermissionGroupResult call() throws Exception {
                DisassociateUserFromPermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeDisassociateUserFromPermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableUserResult> enableUserAsync(EnableUserRequest request) {
        return this.enableUserAsync(request, null);
    }

    @Override
    public Future<EnableUserResult> enableUserAsync(EnableUserRequest request, final AsyncHandler<EnableUserRequest, EnableUserResult> asyncHandler) {
        final EnableUserRequest finalRequest = (EnableUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableUserResult>(){

            @Override
            public EnableUserResult call() throws Exception {
                EnableUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeEnableUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChangesetResult> getChangesetAsync(GetChangesetRequest request) {
        return this.getChangesetAsync(request, null);
    }

    @Override
    public Future<GetChangesetResult> getChangesetAsync(GetChangesetRequest request, final AsyncHandler<GetChangesetRequest, GetChangesetResult> asyncHandler) {
        final GetChangesetRequest finalRequest = (GetChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChangesetResult>(){

            @Override
            public GetChangesetResult call() throws Exception {
                GetChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataViewResult> getDataViewAsync(GetDataViewRequest request) {
        return this.getDataViewAsync(request, null);
    }

    @Override
    public Future<GetDataViewResult> getDataViewAsync(GetDataViewRequest request, final AsyncHandler<GetDataViewRequest, GetDataViewResult> asyncHandler) {
        final GetDataViewRequest finalRequest = (GetDataViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataViewResult>(){

            @Override
            public GetDataViewResult call() throws Exception {
                GetDataViewResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetDataView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatasetResult> getDatasetAsync(GetDatasetRequest request) {
        return this.getDatasetAsync(request, null);
    }

    @Override
    public Future<GetDatasetResult> getDatasetAsync(GetDatasetRequest request, final AsyncHandler<GetDatasetRequest, GetDatasetResult> asyncHandler) {
        final GetDatasetRequest finalRequest = (GetDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatasetResult>(){

            @Override
            public GetDatasetResult call() throws Exception {
                GetDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPermissionGroupResult> getPermissionGroupAsync(GetPermissionGroupRequest request) {
        return this.getPermissionGroupAsync(request, null);
    }

    @Override
    public Future<GetPermissionGroupResult> getPermissionGroupAsync(GetPermissionGroupRequest request, final AsyncHandler<GetPermissionGroupRequest, GetPermissionGroupResult> asyncHandler) {
        final GetPermissionGroupRequest finalRequest = (GetPermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPermissionGroupResult>(){

            @Override
            public GetPermissionGroupResult call() throws Exception {
                GetPermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetPermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request) {
        return this.getProgrammaticAccessCredentialsAsync(request, null);
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request, final AsyncHandler<GetProgrammaticAccessCredentialsRequest, GetProgrammaticAccessCredentialsResult> asyncHandler) {
        final GetProgrammaticAccessCredentialsRequest finalRequest = (GetProgrammaticAccessCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProgrammaticAccessCredentialsResult>(){

            @Override
            public GetProgrammaticAccessCredentialsResult call() throws Exception {
                GetProgrammaticAccessCredentialsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetProgrammaticAccessCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request) {
        return this.getUserAsync(request, null);
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request, final AsyncHandler<GetUserRequest, GetUserResult> asyncHandler) {
        final GetUserRequest finalRequest = (GetUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUserResult>(){

            @Override
            public GetUserResult call() throws Exception {
                GetUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request) {
        return this.getWorkingLocationAsync(request, null);
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request, final AsyncHandler<GetWorkingLocationRequest, GetWorkingLocationResult> asyncHandler) {
        final GetWorkingLocationRequest finalRequest = (GetWorkingLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkingLocationResult>(){

            @Override
            public GetWorkingLocationResult call() throws Exception {
                GetWorkingLocationResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetWorkingLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangesetsResult> listChangesetsAsync(ListChangesetsRequest request) {
        return this.listChangesetsAsync(request, null);
    }

    @Override
    public Future<ListChangesetsResult> listChangesetsAsync(ListChangesetsRequest request, final AsyncHandler<ListChangesetsRequest, ListChangesetsResult> asyncHandler) {
        final ListChangesetsRequest finalRequest = (ListChangesetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangesetsResult>(){

            @Override
            public ListChangesetsResult call() throws Exception {
                ListChangesetsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListChangesets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataViewsResult> listDataViewsAsync(ListDataViewsRequest request) {
        return this.listDataViewsAsync(request, null);
    }

    @Override
    public Future<ListDataViewsResult> listDataViewsAsync(ListDataViewsRequest request, final AsyncHandler<ListDataViewsRequest, ListDataViewsResult> asyncHandler) {
        final ListDataViewsRequest finalRequest = (ListDataViewsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataViewsResult>(){

            @Override
            public ListDataViewsResult call() throws Exception {
                ListDataViewsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListDataViews(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionGroupsResult> listPermissionGroupsAsync(ListPermissionGroupsRequest request) {
        return this.listPermissionGroupsAsync(request, null);
    }

    @Override
    public Future<ListPermissionGroupsResult> listPermissionGroupsAsync(ListPermissionGroupsRequest request, final AsyncHandler<ListPermissionGroupsRequest, ListPermissionGroupsResult> asyncHandler) {
        final ListPermissionGroupsRequest finalRequest = (ListPermissionGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionGroupsResult>(){

            @Override
            public ListPermissionGroupsResult call() throws Exception {
                ListPermissionGroupsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListPermissionGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionGroupsByUserResult> listPermissionGroupsByUserAsync(ListPermissionGroupsByUserRequest request) {
        return this.listPermissionGroupsByUserAsync(request, null);
    }

    @Override
    public Future<ListPermissionGroupsByUserResult> listPermissionGroupsByUserAsync(ListPermissionGroupsByUserRequest request, final AsyncHandler<ListPermissionGroupsByUserRequest, ListPermissionGroupsByUserResult> asyncHandler) {
        final ListPermissionGroupsByUserRequest finalRequest = (ListPermissionGroupsByUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionGroupsByUserResult>(){

            @Override
            public ListPermissionGroupsByUserResult call() throws Exception {
                ListPermissionGroupsByUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListPermissionGroupsByUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersByPermissionGroupResult> listUsersByPermissionGroupAsync(ListUsersByPermissionGroupRequest request) {
        return this.listUsersByPermissionGroupAsync(request, null);
    }

    @Override
    public Future<ListUsersByPermissionGroupResult> listUsersByPermissionGroupAsync(ListUsersByPermissionGroupRequest request, final AsyncHandler<ListUsersByPermissionGroupRequest, ListUsersByPermissionGroupResult> asyncHandler) {
        final ListUsersByPermissionGroupRequest finalRequest = (ListUsersByPermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersByPermissionGroupResult>(){

            @Override
            public ListUsersByPermissionGroupResult call() throws Exception {
                ListUsersByPermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListUsersByPermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetUserPasswordResult> resetUserPasswordAsync(ResetUserPasswordRequest request) {
        return this.resetUserPasswordAsync(request, null);
    }

    @Override
    public Future<ResetUserPasswordResult> resetUserPasswordAsync(ResetUserPasswordRequest request, final AsyncHandler<ResetUserPasswordRequest, ResetUserPasswordResult> asyncHandler) {
        final ResetUserPasswordRequest finalRequest = (ResetUserPasswordRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetUserPasswordResult>(){

            @Override
            public ResetUserPasswordResult call() throws Exception {
                ResetUserPasswordResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeResetUserPassword(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChangesetResult> updateChangesetAsync(UpdateChangesetRequest request) {
        return this.updateChangesetAsync(request, null);
    }

    @Override
    public Future<UpdateChangesetResult> updateChangesetAsync(UpdateChangesetRequest request, final AsyncHandler<UpdateChangesetRequest, UpdateChangesetResult> asyncHandler) {
        final UpdateChangesetRequest finalRequest = (UpdateChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChangesetResult>(){

            @Override
            public UpdateChangesetResult call() throws Exception {
                UpdateChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdateChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request) {
        return this.updateDatasetAsync(request, null);
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request, final AsyncHandler<UpdateDatasetRequest, UpdateDatasetResult> asyncHandler) {
        final UpdateDatasetRequest finalRequest = (UpdateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDatasetResult>(){

            @Override
            public UpdateDatasetResult call() throws Exception {
                UpdateDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePermissionGroupResult> updatePermissionGroupAsync(UpdatePermissionGroupRequest request) {
        return this.updatePermissionGroupAsync(request, null);
    }

    @Override
    public Future<UpdatePermissionGroupResult> updatePermissionGroupAsync(UpdatePermissionGroupRequest request, final AsyncHandler<UpdatePermissionGroupRequest, UpdatePermissionGroupResult> asyncHandler) {
        final UpdatePermissionGroupRequest finalRequest = (UpdatePermissionGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePermissionGroupResult>(){

            @Override
            public UpdatePermissionGroupResult call() throws Exception {
                UpdatePermissionGroupResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdatePermissionGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

