/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.entityresolution.model.IdMappingJobOutputSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartIdMappingJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<IdMappingJobOutputSource> outputSourceConfig;
    private String workflowName;

    public List<IdMappingJobOutputSource> getOutputSourceConfig() {
        return this.outputSourceConfig;
    }

    public void setOutputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
        if (outputSourceConfig == null) {
            this.outputSourceConfig = null;
            return;
        }
        this.outputSourceConfig = new ArrayList<IdMappingJobOutputSource>(outputSourceConfig);
    }

    public StartIdMappingJobRequest withOutputSourceConfig(IdMappingJobOutputSource ... outputSourceConfig) {
        if (this.outputSourceConfig == null) {
            this.setOutputSourceConfig(new ArrayList<IdMappingJobOutputSource>(outputSourceConfig.length));
        }
        for (IdMappingJobOutputSource ele : outputSourceConfig) {
            this.outputSourceConfig.add(ele);
        }
        return this;
    }

    public StartIdMappingJobRequest withOutputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
        this.setOutputSourceConfig(outputSourceConfig);
        return this;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public StartIdMappingJobRequest withWorkflowName(String workflowName) {
        this.setWorkflowName(workflowName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutputSourceConfig() != null) {
            sb.append("OutputSourceConfig: ").append(this.getOutputSourceConfig()).append(",");
        }
        if (this.getWorkflowName() != null) {
            sb.append("WorkflowName: ").append(this.getWorkflowName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIdMappingJobRequest)) {
            return false;
        }
        StartIdMappingJobRequest other = (StartIdMappingJobRequest)obj;
        if (other.getOutputSourceConfig() == null ^ this.getOutputSourceConfig() == null) {
            return false;
        }
        if (other.getOutputSourceConfig() != null && !other.getOutputSourceConfig().equals(this.getOutputSourceConfig())) {
            return false;
        }
        if (other.getWorkflowName() == null ^ this.getWorkflowName() == null) {
            return false;
        }
        return other.getWorkflowName() == null || other.getWorkflowName().equals(this.getWorkflowName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutputSourceConfig() == null ? 0 : this.getOutputSourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowName() == null ? 0 : this.getWorkflowName().hashCode());
        return hashCode;
    }

    public StartIdMappingJobRequest clone() {
        return (StartIdMappingJobRequest)super.clone();
    }
}

