/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticmapreduce.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The Amazon Linux release specified for a cluster in the RunJobFlow request.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/OSRelease" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OSRelease implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     * href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     * Notes</i> </a>. For example, 2.0.20220218.1.
     * </p>
     */
    private String label;

    /**
     * <p>
     * The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     * href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     * Notes</i> </a>. For example, 2.0.20220218.1.
     * </p>
     * 
     * @param label
     *        The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     *        href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     *        Notes</i> </a>. For example, 2.0.20220218.1.
     */

    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * <p>
     * The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     * href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     * Notes</i> </a>. For example, 2.0.20220218.1.
     * </p>
     * 
     * @return The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     *         href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     *         Notes</i> </a>. For example, 2.0.20220218.1.
     */

    public String getLabel() {
        return this.label;
    }

    /**
     * <p>
     * The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     * href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     * Notes</i> </a>. For example, 2.0.20220218.1.
     * </p>
     * 
     * @param label
     *        The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a
     *        href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release
     *        Notes</i> </a>. For example, 2.0.20220218.1.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OSRelease withLabel(String label) {
        setLabel(label);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLabel() != null)
            sb.append("Label: ").append(getLabel());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OSRelease == false)
            return false;
        OSRelease other = (OSRelease) obj;
        if (other.getLabel() == null ^ this.getLabel() == null)
            return false;
        if (other.getLabel() != null && other.getLabel().equals(this.getLabel()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLabel() == null) ? 0 : getLabel().hashCode());
        return hashCode;
    }

    @Override
    public OSRelease clone() {
        try {
            return (OSRelease) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.elasticmapreduce.model.transform.OSReleaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
