/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.AnomalyDetection;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AnomalyDetectionStaxUnmarshaller
implements Unmarshaller<AnomalyDetection, StaxUnmarshallerContext> {
    private static AnomalyDetectionStaxUnmarshaller instance;

    public AnomalyDetection unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnomalyDetection anomalyDetection = new AnomalyDetection();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return anomalyDetection;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Result", targetDepth)) {
                    anomalyDetection.setResult(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MitigationInEffect", targetDepth)) continue;
                anomalyDetection.setMitigationInEffect(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return anomalyDetection;
    }

    public static AnomalyDetectionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AnomalyDetectionStaxUnmarshaller();
        }
        return instance;
    }
}

