/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import com.amazonaws.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateTagsForResourceRequestMarshaller
implements Marshaller<Request<UpdateTagsForResourceRequest>, UpdateTagsForResourceRequest> {
    public Request<UpdateTagsForResourceRequest> marshall(UpdateTagsForResourceRequest updateTagsForResourceRequest) {
        if (updateTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTagsForResourceRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateTagsForResource");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateTagsForResourceRequest.getResourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString((String)updateTagsForResourceRequest.getResourceArn()));
        }
        if (!updateTagsForResourceRequest.getTagsToAdd().isEmpty() || !((SdkInternalList)updateTagsForResourceRequest.getTagsToAdd()).isAutoConstruct()) {
            SdkInternalList tagsToAddList = (SdkInternalList)updateTagsForResourceRequest.getTagsToAdd();
            int tagsToAddListIndex = 1;
            for (Tag tagsToAddListValue : tagsToAddList) {
                if (tagsToAddListValue != null) {
                    if (tagsToAddListValue.getKey() != null) {
                        request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Key", StringUtils.fromString((String)tagsToAddListValue.getKey()));
                    }
                    if (tagsToAddListValue.getValue() != null) {
                        request.addParameter("TagsToAdd.member." + tagsToAddListIndex + ".Value", StringUtils.fromString((String)tagsToAddListValue.getValue()));
                    }
                }
                ++tagsToAddListIndex;
            }
        }
        if (!updateTagsForResourceRequest.getTagsToRemove().isEmpty() || !((SdkInternalList)updateTagsForResourceRequest.getTagsToRemove()).isAutoConstruct()) {
            SdkInternalList tagsToRemoveList = (SdkInternalList)updateTagsForResourceRequest.getTagsToRemove();
            int tagsToRemoveListIndex = 1;
            for (String tagsToRemoveListValue : tagsToRemoveList) {
                if (tagsToRemoveListValue != null) {
                    request.addParameter("TagsToRemove.member." + tagsToRemoveListIndex, StringUtils.fromString((String)tagsToRemoveListValue));
                }
                ++tagsToRemoveListIndex;
            }
        }
        return request;
    }
}

