/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyUserGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyUserGroupRequestMarshaller
implements Marshaller<Request<ModifyUserGroupRequest>, ModifyUserGroupRequest> {
    public Request<ModifyUserGroupRequest> marshall(ModifyUserGroupRequest modifyUserGroupRequest) {
        if (modifyUserGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyUserGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyUserGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyUserGroupRequest.getUserGroupId() != null) {
            request.addParameter("UserGroupId", StringUtils.fromString((String)modifyUserGroupRequest.getUserGroupId()));
        }
        if (!modifyUserGroupRequest.getUserIdsToAdd().isEmpty() || !((SdkInternalList)modifyUserGroupRequest.getUserIdsToAdd()).isAutoConstruct()) {
            SdkInternalList userIdsToAddList = (SdkInternalList)modifyUserGroupRequest.getUserIdsToAdd();
            int userIdsToAddListIndex = 1;
            for (String userIdsToAddListValue : userIdsToAddList) {
                if (userIdsToAddListValue != null) {
                    request.addParameter("UserIdsToAdd.member." + userIdsToAddListIndex, StringUtils.fromString((String)userIdsToAddListValue));
                }
                ++userIdsToAddListIndex;
            }
        }
        if (!modifyUserGroupRequest.getUserIdsToRemove().isEmpty() || !((SdkInternalList)modifyUserGroupRequest.getUserIdsToRemove()).isAutoConstruct()) {
            SdkInternalList userIdsToRemoveList = (SdkInternalList)modifyUserGroupRequest.getUserIdsToRemove();
            int userIdsToRemoveListIndex = 1;
            for (String userIdsToRemoveListValue : userIdsToRemoveList) {
                if (userIdsToRemoveListValue != null) {
                    request.addParameter("UserIdsToRemove.member." + userIdsToRemoveListIndex, StringUtils.fromString((String)userIdsToRemoveListValue));
                }
                ++userIdsToRemoveListIndex;
            }
        }
        return request;
    }
}

