/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.DataStorage;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DataStorageStaxUnmarshaller
implements Unmarshaller<DataStorage, StaxUnmarshallerContext> {
    private static DataStorageStaxUnmarshaller instance;

    public DataStorage unmarshall(StaxUnmarshallerContext context) throws Exception {
        DataStorage dataStorage = new DataStorage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dataStorage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Maximum", targetDepth)) {
                    dataStorage.setMaximum(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    dataStorage.setMinimum(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Unit", targetDepth)) continue;
                dataStorage.setUnit(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dataStorage;
    }

    public static DataStorageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataStorageStaxUnmarshaller();
        }
        return instance;
    }
}

