/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String replicationGroupId;
    private String cacheClusterId;
    private String snapshotName;
    private String kmsKeyId;
    private SdkInternalList<Tag> tags;

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public CreateSnapshotRequest withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public CreateSnapshotRequest withCacheClusterId(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
        return this;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public CreateSnapshotRequest withSnapshotName(String snapshotName) {
        this.setSnapshotName(snapshotName);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateSnapshotRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.getReplicationGroupId()).append(",");
        }
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.getCacheClusterId()).append(",");
        }
        if (this.getSnapshotName() != null) {
            sb.append("SnapshotName: ").append(this.getSnapshotName()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getSnapshotName() == null ^ this.getSnapshotName() == null) {
            return false;
        }
        if (other.getSnapshotName() != null && !other.getSnapshotName().equals(this.getSnapshotName())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotName() == null ? 0 : this.getSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest)super.clone();
    }
}

