/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.CacheSecurityGroupMembership;
import com.amazonaws.services.elasticache.model.SecurityGroupMembership;
import com.amazonaws.services.elasticache.model.transform.CacheNodeStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheParameterGroupStatusStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheSecurityGroupMembershipStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.EndpointStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.NotificationConfigurationStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.PendingModifiedValuesStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.SecurityGroupMembershipStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CacheClusterStaxUnmarshaller
implements Unmarshaller<CacheCluster, StaxUnmarshallerContext> {
    private static CacheClusterStaxUnmarshaller instance;

    public CacheCluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheCluster cacheCluster = new CacheCluster();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cacheCluster;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    cacheCluster.setCacheClusterId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationEndpoint", targetDepth)) {
                    cacheCluster.setConfigurationEndpoint(EndpointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClientDownloadLandingPage", targetDepth)) {
                    cacheCluster.setClientDownloadLandingPage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeType", targetDepth)) {
                    cacheCluster.setCacheNodeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    cacheCluster.setEngine(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    cacheCluster.setEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheClusterStatus", targetDepth)) {
                    cacheCluster.setCacheClusterStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NumCacheNodes", targetDepth)) {
                    cacheCluster.setNumCacheNodes(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredAvailabilityZone", targetDepth)) {
                    cacheCluster.setPreferredAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheClusterCreateTime", targetDepth)) {
                    cacheCluster.setCacheClusterCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    cacheCluster.setPreferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    cacheCluster.setPendingModifiedValues(PendingModifiedValuesStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NotificationConfiguration", targetDepth)) {
                    cacheCluster.setNotificationConfiguration(NotificationConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSecurityGroups", targetDepth)) {
                    cacheCluster.withCacheSecurityGroups(new ArrayList<CacheSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("CacheSecurityGroups/CacheSecurityGroup", targetDepth)) {
                    cacheCluster.withCacheSecurityGroups(CacheSecurityGroupMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheParameterGroup", targetDepth)) {
                    cacheCluster.setCacheParameterGroup(CacheParameterGroupStatusStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSubnetGroupName", targetDepth)) {
                    cacheCluster.setCacheSubnetGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodes", targetDepth)) {
                    cacheCluster.withCacheNodes(new ArrayList<CacheNode>());
                    continue;
                }
                if (context.testExpression("CacheNodes/CacheNode", targetDepth)) {
                    cacheCluster.withCacheNodes(CacheNodeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    cacheCluster.setAutoMinorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroups", targetDepth)) {
                    cacheCluster.withSecurityGroups(new ArrayList<SecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    cacheCluster.withSecurityGroups(SecurityGroupMembershipStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationGroupId", targetDepth)) {
                    cacheCluster.setReplicationGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnapshotRetentionLimit", targetDepth)) {
                    cacheCluster.setSnapshotRetentionLimit(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SnapshotWindow", targetDepth)) continue;
                cacheCluster.setSnapshotWindow(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cacheCluster;
    }

    public static CacheClusterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CacheClusterStaxUnmarshaller();
        }
        return instance;
    }
}

