/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Compatibility;
import com.amazonaws.services.eks.model.transform.AddonVersionInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddonVersionInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String addonVersion;
    private List<String> architecture;
    private List<Compatibility> compatibilities;

    public void setAddonVersion(String addonVersion) {
        this.addonVersion = addonVersion;
    }

    public String getAddonVersion() {
        return this.addonVersion;
    }

    public AddonVersionInfo withAddonVersion(String addonVersion) {
        this.setAddonVersion(addonVersion);
        return this;
    }

    public List<String> getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Collection<String> architecture) {
        if (architecture == null) {
            this.architecture = null;
            return;
        }
        this.architecture = new ArrayList<String>(architecture);
    }

    public AddonVersionInfo withArchitecture(String ... architecture) {
        if (this.architecture == null) {
            this.setArchitecture(new ArrayList<String>(architecture.length));
        }
        for (String ele : architecture) {
            this.architecture.add(ele);
        }
        return this;
    }

    public AddonVersionInfo withArchitecture(Collection<String> architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public List<Compatibility> getCompatibilities() {
        return this.compatibilities;
    }

    public void setCompatibilities(Collection<Compatibility> compatibilities) {
        if (compatibilities == null) {
            this.compatibilities = null;
            return;
        }
        this.compatibilities = new ArrayList<Compatibility>(compatibilities);
    }

    public AddonVersionInfo withCompatibilities(Compatibility ... compatibilities) {
        if (this.compatibilities == null) {
            this.setCompatibilities(new ArrayList<Compatibility>(compatibilities.length));
        }
        for (Compatibility ele : compatibilities) {
            this.compatibilities.add(ele);
        }
        return this;
    }

    public AddonVersionInfo withCompatibilities(Collection<Compatibility> compatibilities) {
        this.setCompatibilities(compatibilities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddonVersion() != null) {
            sb.append("AddonVersion: ").append(this.getAddonVersion()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getCompatibilities() != null) {
            sb.append("Compatibilities: ").append(this.getCompatibilities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonVersionInfo)) {
            return false;
        }
        AddonVersionInfo other = (AddonVersionInfo)obj;
        if (other.getAddonVersion() == null ^ this.getAddonVersion() == null) {
            return false;
        }
        if (other.getAddonVersion() != null && !other.getAddonVersion().equals(this.getAddonVersion())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getCompatibilities() == null ^ this.getCompatibilities() == null) {
            return false;
        }
        return other.getCompatibilities() == null || other.getCompatibilities().equals(this.getCompatibilities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddonVersion() == null ? 0 : this.getAddonVersion().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getCompatibilities() == null ? 0 : this.getCompatibilities().hashCode());
        return hashCode;
    }

    public AddonVersionInfo clone() {
        try {
            return (AddonVersionInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddonVersionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

