/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.AddonIssue;
import com.amazonaws.services.eks.model.transform.AddonHealthMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddonHealth
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AddonIssue> issues;

    public List<AddonIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Collection<AddonIssue> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }
        this.issues = new ArrayList<AddonIssue>(issues);
    }

    public AddonHealth withIssues(AddonIssue ... issues) {
        if (this.issues == null) {
            this.setIssues(new ArrayList<AddonIssue>(issues.length));
        }
        for (AddonIssue ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    public AddonHealth withIssues(Collection<AddonIssue> issues) {
        this.setIssues(issues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssues() != null) {
            sb.append("Issues: ").append(this.getIssues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonHealth)) {
            return false;
        }
        AddonHealth other = (AddonHealth)obj;
        if (other.getIssues() == null ^ this.getIssues() == null) {
            return false;
        }
        return other.getIssues() == null || other.getIssues().equals(this.getIssues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssues() == null ? 0 : this.getIssues().hashCode());
        return hashCode;
    }

    public AddonHealth clone() {
        try {
            return (AddonHealth)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddonHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

