/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecs.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.ecs.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DeploymentConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DeploymentConfigurationMarshaller {

    private static final MarshallingInfo<StructuredPojo> DEPLOYMENTCIRCUITBREAKER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentCircuitBreaker").build();
    private static final MarshallingInfo<Integer> MAXIMUMPERCENT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumPercent").build();
    private static final MarshallingInfo<Integer> MINIMUMHEALTHYPERCENT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumHealthyPercent").build();
    private static final MarshallingInfo<StructuredPojo> ALARMS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alarms").build();

    private static final DeploymentConfigurationMarshaller instance = new DeploymentConfigurationMarshaller();

    public static DeploymentConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DeploymentConfiguration deploymentConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (deploymentConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(deploymentConfiguration.getDeploymentCircuitBreaker(), DEPLOYMENTCIRCUITBREAKER_BINDING);
            protocolMarshaller.marshall(deploymentConfiguration.getMaximumPercent(), MAXIMUMPERCENT_BINDING);
            protocolMarshaller.marshall(deploymentConfiguration.getMinimumHealthyPercent(), MINIMUMHEALTHYPERCENT_BINDING);
            protocolMarshaller.marshall(deploymentConfiguration.getAlarms(), ALARMS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
