/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.CapacityProviderStrategyItem;
import com.amazonaws.services.ecs.model.ClusterConfiguration;
import com.amazonaws.services.ecs.model.ClusterSetting;
import com.amazonaws.services.ecs.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterName;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<ClusterSetting> settings;
    private ClusterConfiguration configuration;
    private SdkInternalList<String> capacityProviders;
    private SdkInternalList<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public CreateClusterRequest withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateClusterRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<ClusterSetting> getSettings() {
        if (this.settings == null) {
            this.settings = new SdkInternalList();
        }
        return this.settings;
    }

    public void setSettings(Collection<ClusterSetting> settings) {
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new SdkInternalList(settings);
    }

    public CreateClusterRequest withSettings(ClusterSetting ... settings) {
        if (this.settings == null) {
            this.setSettings((Collection<ClusterSetting>)new SdkInternalList(settings.length));
        }
        for (ClusterSetting ele : settings) {
            this.settings.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withSettings(Collection<ClusterSetting> settings) {
        this.setSettings(settings);
        return this;
    }

    public void setConfiguration(ClusterConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateClusterRequest withConfiguration(ClusterConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<String> getCapacityProviders() {
        if (this.capacityProviders == null) {
            this.capacityProviders = new SdkInternalList();
        }
        return this.capacityProviders;
    }

    public void setCapacityProviders(Collection<String> capacityProviders) {
        if (capacityProviders == null) {
            this.capacityProviders = null;
            return;
        }
        this.capacityProviders = new SdkInternalList(capacityProviders);
    }

    public CreateClusterRequest withCapacityProviders(String ... capacityProviders) {
        if (this.capacityProviders == null) {
            this.setCapacityProviders((Collection<String>)new SdkInternalList(capacityProviders.length));
        }
        for (String ele : capacityProviders) {
            this.capacityProviders.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withCapacityProviders(Collection<String> capacityProviders) {
        this.setCapacityProviders(capacityProviders);
        return this;
    }

    public List<CapacityProviderStrategyItem> getDefaultCapacityProviderStrategy() {
        if (this.defaultCapacityProviderStrategy == null) {
            this.defaultCapacityProviderStrategy = new SdkInternalList();
        }
        return this.defaultCapacityProviderStrategy;
    }

    public void setDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
        if (defaultCapacityProviderStrategy == null) {
            this.defaultCapacityProviderStrategy = null;
            return;
        }
        this.defaultCapacityProviderStrategy = new SdkInternalList(defaultCapacityProviderStrategy);
    }

    public CreateClusterRequest withDefaultCapacityProviderStrategy(CapacityProviderStrategyItem ... defaultCapacityProviderStrategy) {
        if (this.defaultCapacityProviderStrategy == null) {
            this.setDefaultCapacityProviderStrategy((Collection<CapacityProviderStrategyItem>)new SdkInternalList(defaultCapacityProviderStrategy.length));
        }
        for (CapacityProviderStrategyItem ele : defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy.add((Object)ele);
        }
        return this;
    }

    public CreateClusterRequest withDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
        this.setDefaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getCapacityProviders() != null) {
            sb.append("CapacityProviders: ").append(this.getCapacityProviders()).append(",");
        }
        if (this.getDefaultCapacityProviderStrategy() != null) {
            sb.append("DefaultCapacityProviderStrategy: ").append(this.getDefaultCapacityProviderStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)obj;
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getCapacityProviders() == null ^ this.getCapacityProviders() == null) {
            return false;
        }
        if (other.getCapacityProviders() != null && !other.getCapacityProviders().equals(this.getCapacityProviders())) {
            return false;
        }
        if (other.getDefaultCapacityProviderStrategy() == null ^ this.getDefaultCapacityProviderStrategy() == null) {
            return false;
        }
        return other.getDefaultCapacityProviderStrategy() == null || other.getDefaultCapacityProviderStrategy().equals(this.getDefaultCapacityProviderStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityProviders() == null ? 0 : this.getCapacityProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCapacityProviderStrategy() == null ? 0 : this.getDefaultCapacityProviderStrategy().hashCode());
        return hashCode;
    }

    public CreateClusterRequest clone() {
        return (CreateClusterRequest)super.clone();
    }
}

